@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($banner,array('route' => array('admin.banner.update',$banner->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $banner->id)}}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('status', translateText('وضعیت',lang_admin()).' *')}}
                                {{ Form::select('status', ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search')) }}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('title', translateText('عنوان',lang_admin()))}}
                                {{Form::text('title',null, array('class' => 'form-control'))}}
                            </div>
                        </div>
{{--                        <div class="col-md-4">--}}
{{--                            <div class="form-group">--}}
{{--                                {{Form::label('place', 'مکان  *')}}--}}
{{--                                {{ Form::select('place', ['index_1'=>'صفحه اصلی(زیر اسلایدر)','index_2'=>'صفحه اصلی(زیر suppliers)'], null, array('class' => 'form-control select2-show-search')) }}--}}
{{--                            </div>--}}
{{--                        </div>--}}
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('link', translateText('لینک',lang_admin()))}}
                                {{Form::url('link', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $banner->photo ? $banner->photo->id : 0,'data-default-file'=>$banner->photo && is_file($banner->photo->path)?url($banner->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 800 پیکسل در ارتفاع 220 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG,GIF باشد',lang_admin())}}</small></p>
                        </div>
                        @if($banner->place=='index_1')
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('photo_default', translateText('تصویر پیش فرض',lang_admin()))}}
                                {{Form::file('photo_default', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $banner->photo_default ? $banner->photo_default->id : 0,'data-default-file'=>$banner->photo_default && is_file($banner->photo_default->path)?url($banner->photo_default->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 800 پیکسل در ارتفاع 220 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG,GIF باشد',lang_admin())}}</small></p>
                        </div>
                        @endif

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@push('in_tag_script')

@endpush
