@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true]))

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.learning.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select','required')) }}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('متن',lang_admin()))}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('slug', 'Slug *')}}
                                {{ Form::text('slug', null, array('class' => 'form-control slug_input','data-placeholder'=>'انتخاب کنید','required')) }}
                            </div>
                            <p class="text-danger">_<small>{{translateText('این قسمت برای آدرس صفحه استفاده می شود.',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('link', translateText('لینک ویدئو',lang_admin()))}}
                                {{Form::text('link', $item->link, array('class' => 'form-control'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت اینکه ویدئو آپلود نکردین لینک ویدئو را قرار دهید.',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 600 پیکسل در ارتفاع 400 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('video', translateText('ویدئو',lang_admin()))}}
                                {{Form::file('video', array('class' => 'dropify','data-height'=>'180','accept' => '.mp4','id' => $item->video ? $item->video->id : 0,'data-default-file'=>$item->video && is_file($item->video->path)?url($item->video->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت اینکه لینکی وارد نکردین ویدئو را آپلود کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 30MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید MP4 باشد',lang_admin())}}</small></p>
                            @if($item->video && is_file($item->video->path))
                                <p class="text-danger">_<small><a href="{{url($item->video->path)}}">{{translateText('نمایش ویدئو',lang_admin())}}</a></small></p>
                                <p class="text-danger">_<small><a href="{{route('admin.pic.delete',$item->video->id)}}" onclick="return confirm('{{translateText('برای حذف ویدئو مطمئن هستید؟',lang_admin())}}')">{{translateText('حذف ویدئو',lang_admin())}}</a></small></p>
                            @endif
                        </div>

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>
@endsection
