@php
  $i=0;
@endphp
@foreach($items as $item)
  @php
    $i++;
  @endphp
  <tr>
      <td dir="ltr">
          {{ $parent_number }} - {{ $loop->iteration < 10 ? "0".$loop->iteration : $loop->iteration }}
      </td>
      <td>
          @for($i = 0; $i < $level; $i++)
              &nbsp;&nbsp;&nbsp;&nbsp;
          @endfor
          └─ {{$item->title}}
      </td>
      <td>
          @if($item->photo && is_file($item->photo->path))
              <img src="{{url($item->photo->path)}}" height="100px">
          @else
              {{translateText('ثبت نشده',lang_admin())}}
          @endif
      </td>
    @can('product_category_sort')
      <td>
        {!! Form::open(['method' => 'POST', 'route' => ['admin.product-category.sort', $item->id] ]) !!}
        <input type="number" name="sort" class="form-control w-60px" value="{{$item->sort}}" onchange="return this.form.submit()">
        {!! Form::close() !!}
      </td>
    @endcan
    @canany(['product_category_edit','product_category_delete'])
      <td>
        <div class="d-flex">
          @can('product_category_edit')
            <a href="{{route('admin.product-category.edit',$item->id)}}"
               class="action-btns1">
              <i class="feather feather-edit-2  text-success"
                 data-toggle="tooltip" data-placement="top"
                 title="{{translateText('ویرایش',lang_admin())}}"></i>
            </a>
          @endcan
          @can('product_category_delete')
            {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product-category.destroy', $item->id] ]) !!}
            <button class="action-btns1" data-toggle="tooltip"
                    data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                    onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
              <i class="feather feather-trash-2 text-danger"></i>
            </button>
            {!! Form::close() !!}
          @endcan
        </div>
      </td>
    @endcan
  </tr>
  @if(count($item->children))
      @include('admin.product.category.each', [
          'items' => $item->children,
          'level' => $level + 1,
          'parent_number' => $parent_number.' - '.($loop->iteration < 10 ? "0".$loop->iteration : $loop->iteration)
      ])
  @endif
{{--  @if(count($item->childs))--}}
{{--      @include('admin.product.category.each',['items'=>$item->childs,'number'=>$number.' - '.$i < 10 ? "0$i" : $i])--}}
{{--  @endif--}}
@endforeach