@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        .box-sh
        {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 10px;
            padding: 15px 15px;

        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('product_category_create')
                            <a href="{{route('admin.product-category.create')}}" class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
{{--                    @if(request()->r==125)--}}
{{--                        <div class="container-fluid mb-3">--}}
{{--                            {{ Form::open(array('route' => 'admin.product-category.import', 'method' => 'POST','class'=>'row box-sh mt-2','files'=>true)) }}--}}
{{--                            <div class="col-12">--}}
{{--                                <h5>ورودی اکسل</h5>--}}
{{--                                <hr/>--}}
{{--                                <input type="file" name="file" accept=".xls,.xlsx">--}}
{{--                            </div>--}}
{{--                            <div class="col-md-12 text-left">--}}
{{--                                <button type="submit" class="btn btn-info">ارسال</button>--}}
{{--                            </div>--}}
{{--                            {{ Form::close() }}--}}
{{--                        </div>--}}
{{--                    @endif--}}
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('عنوان/نام محصول',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('تصویر',lang_admin())}}</th>
                                @can('product_category_sort')
                                    <th class="border-bottom-0">{{translateText('Sort',lang_admin())}}</th>
                                @endcan
                                @canany(['product_category_edit','product_category_delete'])
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td dir="ltr">{{$key+1 < 10 ? "0".$key+1 : $key+1}}</td>
                                    <td>{{$item->title}}</td>
                                    <td>
                                        @if($item->photo && is_file($item->photo->path))
                                            <img src="{{url($item->photo->path)}}" height="100px">
                                        @else
                                            {{translateText('ثبت نشده',lang_admin())}}
                                        @endif
                                    </td>
                                    @can('product_category_sort')
                                        <td>
                                            {!! Form::open(['method' => 'POST', 'route' => ['admin.product-category.sort', $item->id] ]) !!}
                                            <input type="number" name="sort" class="form-control w-60px"
                                                   value="{{$item->sort}}" onchange="return this.form.submit()">
                                            {!! Form::close() !!}
                                        </td>
                                    @endcan
                                    @canany(['product_category_edit','product_category_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('product_category_edit')
                                                    <a href="{{route('admin.product-category.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                @can('product_category_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product-category.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                                @if(count($item->children))
                                    @include('admin.product.category.each', [
                                        'items' => $item->children,
                                        'level' => 1,
                                        'parent_number' => $key+1 < 10 ? "0".$key+1 : $key+1
                                    ])
                                @endif
                                {{--@if(count($item->childs))
                                    @include('admin.product.category.each',['items'=>$item->childs,'number'=>$key+1 < 10 ? "0".$key+1 : $key+1])
                                @endif--}}
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
