@extends('admin.layouts.app',['req'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.product-category-supplier.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4 d-none">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['active'=>translateText('انتشار',lang_admin()),'pending'=>translateText('عدم انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('نام دسته بندی',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('parent_id1', translateText('Category1',lang_admin()).'*')}}
                                <select name="parent_id1" dir="ltr" id="parent_id1"
                                        class="form-control" required>
                                    <option value="">{{translateText('Selected Category',lang_admin())}}</option>
                                    @foreach($cats as $cat)
                                        <option value="{{$cat->id}}" {{old('parent_id1')==$cat->id?'selected':''}}>{{$cat->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('parent_id2', translateText('Category2',lang_admin()).'*')}}
                                <select name="parent_id2" dir="ltr" id="parent_id2"
                                        class="form-control" required>
                                    <option value="">{{translateText('Selected Category',lang_admin())}}</option>
                                    @foreach($cats2 as $cat)
                                        <option value="{{$cat->id}}" class="parent_id2_cat parent_id2_cat_{{$cat->parent_id}} {{old('parent_id1') && old('parent_id1') == $cat->parent_id ? '' : 'd-none'}}" {{old('parent_id2')==$cat->id?'selected':''}} {{old('parent_id1') && old('parent_id1') == $cat->parent_id ? '' : 'disabled'}}>{{$cat->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('parent_id', translateText('Category3',lang_admin()))}}
                                <select name="parent_id" dir="ltr" id="parent_id"
                                        class="form-control" required>
                                    <option value="father">{{translateText('Selected Category',lang_admin())}}</option>
                                    @foreach($cats3 as $cat)
                                        <option value="{{$cat->id}}" class="parent_id_cat parent_id_cat_{{$cat->parent_id}}  {{old('parent_id2') && old('parent_id2') == $cat->parent_id ? '' : 'd-none'}}" {{old('parent_id')==$cat->id?'selected':''}} {{old('parent_id2') && old('parent_id2') == $cat->parent_id ? '' : 'disabled'}}>{{$cat->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@section('in_tag_script')
<script>
    $('#parent_id1').on('change',function (){
        var value=$(this).val();
        $('.parent_id2_cat').prop('disabled',true)
        $('.parent_id2_cat').addClass('d-none')
        $('.parent_id_cat').prop('disabled',true)
        $('.parent_id_cat').addClass('d-none')
        $('.parent_id2_cat_'+value).prop('disabled',false)
        $('.parent_id2_cat_'+value).removeClass('d-none')
        $('#parent_id2').val('')
        $('#parent_id').val('father')
    })
    $('#parent_id2').on('change',function (){
        var value=$(this).val();
        $('.parent_id_cat').prop('disabled',true)
        $('.parent_id_cat').addClass('d-none')
        $('.parent_id_cat_'+value).prop('disabled',false)
        $('.parent_id_cat_'+value).removeClass('d-none')
        $('#parent_id').val('father')
    })
</script>
@endsection
