@extends('admin.layouts.app',['req'=>true])

@section('content')
    <style>
        .box-sh {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 5px;
            padding: 10px;
            margin-bottom: 20px;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>
                <div class="card-body">
                    <div class="container-fluid box-sh">
                        <form action="{{route('admin.product.feature.store',$product->id)}}" id="frm-req" method="post"
                              class="row">
                            @csrf
                            <div class="col-12">
                                <h5>{{translateText('افزودن',lang_admin())}}</h5>
                                <hr/>
                            </div>
                            <nav class="w-100">
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    @foreach(tab_langs() as $lang)
                                        <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                                id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                                data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                                aria-controls="nav-{{$lang->lang}}"
                                                aria-selected="false">{{$lang->lang}}</button>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content w-100" id="nav-tabContent">
                                @foreach(tab_langs() as $lang)
                                    <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                         id="nav-{{$lang->lang}}" role="tabpanel"
                                         aria-labelledby="nav-{{$lang->lang}}-tab">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان ویژگی(رنگ/...)',lang_admin()).' *')}}
                                                        {{ Form::text($lang->status=='default'?'title':'title_'.$lang->lang, null, array('class' => 'form-control','required')) }}
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        {{Form::label($lang->status=='default'?'value':'value_'.$lang->lang, translateText('مقدار ویژگی(زرد/قرمز/...)',lang_admin()).' *')}}
                                                        {{ Form::text($lang->status=='default'?'value':'value_'.$lang->lang, null, array('class' => 'form-control','required')) }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-md-12 text-left">
                                    {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                                </div>
                        </form>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-vcenter text-wrap table-bordered border-bottom">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('بروزرسانی',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('حذف',lang_admin())}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        <div class="container-fluid box-sh">
                                            <form action="{{route('admin.product.feature.update',$item->id)}}"
                                                  id="frm-req" method="post"
                                                  class="row">
                                                @csrf
                                                <nav class="w-100">
                                                    <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                                        @foreach(tab_langs() as $lang)
                                                            <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                                                    id="nav1-{{$item->id}}-{{$lang->lang}}-tab"
                                                                    data-toggle="tab"
                                                                    data-target="#nav1-{{$item->id}}-{{$lang->lang}}"
                                                                    type="button" role="tab"
                                                                    aria-controls="nav1-{{$item->id}}-{{$lang->lang}}"
                                                                    aria-selected="false">{{$lang->lang}}</button>
                                                        @endforeach
                                                    </div>
                                                </nav>
                                                <div class="tab-content w-100" id="nav-tabContent">
                                                    @foreach(tab_langs() as $lang)
                                                        <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                                             id="nav1-{{$item->id}}-{{$lang->lang}}" role="tabpanel"
                                                             aria-labelledby="nav1-{{$item->id}}-{{$lang->lang}}-tab">
                                                            <div class="container-fluid">
                                                                <div class="row">
                                                                    <div class="col-md-4">
                                                                        <div class="form-group">
                                                                            {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان ویژگی(رنگ/...)',lang_admin()).' *')}}
                                                                            {{ Form::text($lang->status=='default'?'title':'title_'.$lang->lang, read_lang($item,'title',$lang->lang), array('class' => 'form-control','required')) }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <div class="form-group">
                                                                            {{Form::label($lang->status=='default'?'value':'value_'.$lang->lang, translateText('مقدار ویژگی(زرد/قرمز/...)',lang_admin()).' *')}}
                                                                            {{ Form::text($lang->status=='default'?'value':'value_'.$lang->lang, read_lang($item,'value',$lang->lang), array('class' => 'form-control','required')) }}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                                <div class="col-12 text-left">
                                                    <button type="submit"
                                                            class="action-btns1"
                                                            onclick="return confirm('{{translateText('برای ویرایش مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex">

                                            <a href="{{route('admin.product.feature.remove', $item->id)}}"
                                               class="action-btns1" data-toggle="tooltip"
                                               data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                               onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                <i class="feather feather-trash-2 text-danger"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
