@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        .count_badge
        {
            position: absolute;
            right: -15px;
            top: -20px;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('product_create')
                        <a href="{{route('admin.product-service.create')}}" class="btn btn-primary float-left">{{translateText('افزودن خدمت',lang_admin())}}</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('نام خدمت',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('دسته بندی',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('قیمت',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('تصویر',lang_admin())}}</th>
                                @canany(['product_edit','product_delete','product_other'])
                                <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan    
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                       {{$item->title}}
                                        @if(!auth()->user()->hasRole('supplier') && $item->user)
                                            <br/>
                                            <span class="badge badge-danger">{{$item->user->name}}</span>
                                        @endif
                                    </td>
                                    <td dir="ltr">
                                        @if($item->c1)
                                            <span class="badge badge-info mb-1">{{$item->c1->title}}</span>
                                            <br/>
                                        @endif
                                        @if($item->c2)
                                            <span class="badge badge-info mb-1">{{$item->c2->title}}</span>
                                            <br/>
                                        @endif
                                        @if($item->c3)
                                            <span class="badge badge-info mb-1">{{$item->c3->title}}</span>
                                            <br/>
                                        @endif
                                        @if($item->c4)
                                        <span class="badge badge-info">{{$item->c4->title}}</span>
                                            @endif
                                    </td>
                                    <td dir="ltr" class="text-nowrap">
                                        @if(count($item->prices))
                                            From:
                                       {{$item->prices[0]->price}}
                                        <small>$</small>
                                            <br/>
                                        To:
                                            {{$item->price_last->price}}
                                            <small>$</small>
                                        @else
                                            __
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->photo && is_file($item->photo->path))
                                            <img src="{{url($item->photo->path)}}" height="100px" width="100px" style="object-fit: contain">
                                        @else
                                            __
                                        @endif
                                    </td>
                                    @canany(['product_edit','product_delete','product_other'])
                                        <td>
                                            <div class="d-flex">
                                                @can('product_other')
                                                    <a href="{{route('admin.product-service.price',$item->id)}}"
                                                       class="action-btns1 position-relative">
                                                        <i class="feather feather-dollar-sign  text-warning"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('قیمت ها',lang_admin())}}"></i>
                                                        <span class="badge badge-danger count_badge">{{count($item->prices)}}</span>
                                                    </a>
                                                @endcan
                                                @can('product_other')
                                                    <a href="{{route('admin.product-service.feature',$item->id)}}"
                                                       class="action-btns1 position-relative">
                                                        <i class="feather feather-share-2  text-info"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویژگی ها',lang_admin())}}"></i>
                                                        <span class="badge badge-danger count_badge">{{count($item->features)}}</span>
                                                    </a>
                                                @endcan
                                                @can('product_edit')
                                                    <a href="{{route('admin.product-service.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                    @can('product_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product-service.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                    @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
