@extends('admin.layouts.app',['req'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.rfq-form.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select')) }}
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title1':'title1_'.$lang->lang, translateText('عنوان',lang_admin()).' *')}}
                                                    {{Form::text($lang->status=='default'?'title1':'title1_'.$lang->lang,read_lang($item,'title1',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="showForSelect col-12 row"  style="display:none;">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        {{ Form::label($lang->status=='default'?'title2':'title2_'.$lang->lang, translateText('عنوان کامل مخفف',lang_admin())) }}
                                                        {{ Form::text($lang->status=='default'?'title2':'title2_'.$lang->lang, read_lang($item,'title2',$lang->lang), ['class' => 'form-control']) }}
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        {{ Form::label($lang->status=='default'?'title3':'title3_'.$lang->lang, translateText('مخخف با عنوان کامل',lang_admin())) }}
                                                        {{ Form::text($lang->status=='default'?'title3':'title3_'.$lang->lang, read_lang($item,'title3',$lang->lang), ['class' => 'form-control']) }}
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        {{ Form::label($lang->status=='default'?'title4':'title4_'.$lang->lang, translateText('توضیح مختصر',lang_admin())) }}
                                                        {{ Form::text($lang->status=='default'?'title4':'title4_'.$lang->lang, read_lang($item,'title4',$lang->lang), ['class' => 'form-control']) }}
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('type', translateText('تایپ', lang_admin()) . ' *') }}
                                {{ Form::select('type',
                                        [
                                            'units' => translateText('واحد اندازه‌گیری', lang_admin()),
                                            'trade_terms' => translateText('شرایط تجاری', lang_admin()),
                                            'budget_limit' => translateText('حدود بودجه', lang_admin()),
                                            'expected_unit_price' => translateText('قیمت مورد انتظار واحد', lang_admin()),
                                            'bying_frequency' => translateText('تکرار خرید', lang_admin()),
                                            'shipping_method' => translateText('روش حمل و نقل', lang_admin()),
                                            'payment_terms' => translateText('شرایط پرداخت', lang_admin()),
                                            'rfq_expiry' => translateText('انقضای درخواست پیش‌فاکتور', lang_admin())
                                        ],
                                        $item->type,
                                        array('class' => 'form-control select2-show-search custom-select','id' => 'test')
                                    ) }}
                            </div>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@push('in_tag_script')
    <script>
        $(document).ready(function() {
            const $select = $('#test');
            const showForSelectItems = $('.showForSelect');

            function toggleDisplay() {
                if ($select.val() === 'trade_terms') {
                    showForSelectItems.show();
                } else {
                    showForSelectItems.hide();
                }
            }
            toggleDisplay();
            $select.on('change', toggleDisplay);
        });
    </script>
@endpush
