@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('مکان',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('عنوان صفحه',lang_admin())}}</th>
                                @canany(['about_edit','about_option_list'])
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{translateText($item->type_about($item->type),lang_admin())}}</td>
                                    <td>{{$item->title}}</td>
                                    @canany(['about_edit','about_option_list'])
                                        <td>
                                            <div class="d-flex">
                                                @can('about_edit')
                                                    <a href="{{route('admin.about.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                @if($item->type == 'about')
                                                    @can('about_option_list')
                                                        <a href="{{route('admin.about.option.index')}}"
                                                           class="action-btns1">
                                                            <i class="feather feather-share-2  text-info"
                                                               data-toggle="tooltip" data-placement="top"
                                                               title="{{translateText('دیگر اطلاعات',lang_admin())}}"></i>
                                                        </a>
                                                    @endcan
                                                @endif
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
