@extends('admin.layouts.app',['req'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.contact.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,read_lang($item,'title',$lang->lang), array('class' => 'form-control','required'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'address':'address_'.$lang->lang, translateText('آدرس',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'address':'address_'.$lang->lang, read_lang($item,'address',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'time':'time_'.$lang->lang, translateText('زمانبندی',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'time':'time_'.$lang->lang, read_lang($item,'time',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-12 d-none">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 1100 پیکسل در ارتفاع 280 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('address_iframe', translateText('آدرس Iframe',lang_admin()).' *')}}
                                {{Form::text('address_iframe', null, array('class' => 'form-control d-ltr text-left','required'))}}
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('phone', translateText('شماره تماس',lang_admin()).' *')}}
                                {{Form::text('phone', null, array('class' => 'form-control d-ltr text-left contact_multi','required'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت داشتن چند شماره تماس میتوانید با زدن "Add" به تعداد شماره را وارد کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('mobile', translateText('شماره موبایل',lang_admin()))}}
                                {{Form::text('mobile', null, array('class' => 'form-control d-ltr text-left contact_multi'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت داشتن چند شماره موبایل میتوانید با زدن "Add" به تعداد شماره را وارد کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('fax', translateText('شماره فکس',lang_admin()))}}
                                {{Form::text('fax', null, array('class' => 'form-control d-ltr text-left contact_multi'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت داشتن چند شماره فکس میتوانید با زدن "Add" به تعداد شماره را وارد کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('email', translateText('ایمیل',lang_admin()).' *')}}
                                {{Form::text('email', null, array('class' => 'form-control d-ltr text-left contact_multi','required'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت داشتن چند ایمیل میتوانید با زدن "Add" به تعداد ایمیل ها را وارد کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12 d-none">
                            <div class="form-group">
                                {{Form::label('whatsapp', translateText('شماره واتساپ',lang_admin()))}}
                                {{Form::text('whatsapp', null, array('class' => 'form-control d-ltr text-left contact_multi'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('درصورت داشتن چند شماره واتساپ میتوانید با زدن "Add" به تعداد شماره را وارد کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('whatsapp2', translateText(' شماره واتساپ(گوشه سایت)',lang_admin()))}}
                                {{Form::url('whatsapp2', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('این شماره واتساپ می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://api.whatsapp.com/send?phone=989121113355</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('telegram', translateText('تلگرام',lang_admin()))}}
                                {{Form::url('telegram', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://t.me/TelegramId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('instagram', translateText('اینستاگرام',lang_admin()))}}
                                {{Form::url('instagram', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://instagram.com/InstagramId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('facebook', translateText('فیسبوک',lang_admin()))}}
                                {{Form::url('facebook', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.facebook.com/FacebookId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('twitter', translateText('توئیتر',lang_admin()))}}
                                {{Form::url('twitter', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://twitter.com/TwitterId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('linkedin', translateText('لینکدین',lang_admin()))}}
                                {{Form::url('linkedin', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.linkedin.com/in/linkedinId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('youtube', translateText('یوتیوب',lang_admin()))}}
                                {{Form::url('youtube', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.youtube.com/youtubeId</small></p>
                        </div>
                        <div class="col-md-6 d-none">
                            <div class="form-group">
                                {{Form::label('aparat', translateText('آپارات',lang_admin()))}}
                                {{Form::url('aparat', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.aparat.com/aparatId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('whatsapp_group', translateText('گروه واتساپ',lang_admin()))}}
                                {{Form::url('whatsapp_group', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید',lang_admin())}}</small></p>
                            <p class="text-danger">_<small dir="ltr">https://chat.whatsapp.com/GroupId</small></p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>


@endsection
