@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('تصویر',lang_admin())}}</th>
                                <th class="border-bottom-0">URL</th>
                                @can('media_edit_alt')
                                    <th class="border-bottom-0">alt</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        <img src="{{url($item->path)}}" height="100px" loading="lazy">
                                    </td>
                                    <td class="text-left">
                                        <a href="{{url($item->path)}}" target="_blank" dir="ltr">
                                            {{url($item->path)}}
                                        </a>
                                    </td>
                                    @can('media_edit_alt')
                                        <td>
                                            {!! Form::open(['method' => 'POST', 'route' => ['admin.media.edit_alt', $item->id] ]) !!}
                                            {{Form::text('alt', $item->alt, array('class' => 'form-control'))}}
                                            {{ Form::submit(translateText('ویرایش',lang_admin()), ['class' => 'btn btn-primary mt-2', 'onclick' => "return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"]) }}
                                            {!! Form::close() !!}
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
