@extends('admin.layouts.app',['file_upload'=>true,'req'=>true])

@section('styles')
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />
    <style>
        #locateBtn{
            position: absolute;
            top: 11px;
            left: 60px;
            z-index: 999;
        }
    </style>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-lg-12">
                        <div class="panel-body tabs-menu-body hremp-tabs1 p-0">
                            @can('profile_verify')
                                <div class="card-body">
                                    {{ Form::model($address,array('route' => array('admin.profile.updated.address',$address->id), 'method' => 'PATCH','id'=>'form_req','files'=>true)) }}
                                    {{Form::hidden('id', $address->id)}}
                                    <div class="row">
                                        <div class="col-12">
                                            <hr/>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('country_id', translateText('کشور',lang_admin()).' *')}}
                                                {{ Form::select('country_id', array_pluck2($countries, 'nicename', 'phonecode', 'id'), null, array('class' => 'form-control select2-show-search','required')) }}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('full_name', translateText('نام(شرکت/کارخانه)',lang_admin()).' *')}}
                                                {{Form::text('full_name', null, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('phone', translateText('شماره تماس',lang_admin()).' *')}}
                                                {{Form::number('phone', null, array('class' => 'form-control text-left','dir'=>'ltr','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('mobile', translateText('موبایل',lang_admin()))}}
                                                {{Form::number('mobile', null, array('class' => 'form-control text-left','dir'=>'ltr'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('fax', translateText('فکس',lang_admin()))}}
                                                {{Form::number('fax', null, array('class' => 'form-control text-left','dir'=>'ltr'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('email', translateText('ایمیل',lang_admin()).' *')}}
                                                {{Form::email('email', null, array('class' => 'form-control text-left','dir'=>'ltr','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('state', translateText('استان',lang_admin()).' *')}}
                                                {{Form::text('state', null, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('city', translateText('شهر',lang_admin()).' *')}}
                                                {{Form::text('city', null, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="form-group">
                                                {{Form::label('zip_code', 'Zip Code *')}}
                                                {{Form::number('zip_code', null, array('class' => 'form-control text-left','dir'=>'ltr','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                {{Form::label('address', translateText('آدرس',lang_admin()).' *')}}
                                                {{Form::text('address', null, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-lg-12 position-relative">
                                            <button type="button" id="locateBtn" class="btn btn-dark">My Location</button>
                                            <div id="map" style="height: 300px;width: 100%"></div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                {{Form::label('latitude', 'latitude')}}
                                                {{Form::text('latitude', null, array('class' => 'form-control text-center','dir'=>'ltr','readonly'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                {{Form::label('longitude', 'longitude')}}
                                                {{Form::text('longitude', null, array('class' => 'form-control text-center','dir'=>'ltr','readonly'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-12 text-left">
                                            <hr/>
                                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                                        </div>
                                    </div>
                                    {!! Form::close() !!}
                                </div>
                            @endcan
                        </div>
                    </div>
                </div>
                <!-- End Row-->
            </div>
        </div>
    </div>
@endsection
@section('in_tag_script')
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>
    <script>
        var lat = parseFloat({{(float)$address->latitude > 0 && (float)$address->longitude > 0 ? $address->latitude : 37.095 }});
        var lng = parseFloat({{(float)$address->latitude > 0 && (float)$address->longitude > 0 ? $address->longitude : 42.348 }});
        var map = L.map('map').setView([lat, lng], 7);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);

        @if((float)$address->latitude > 0 && (float)$address->longitude > 0)
        var marker = L.marker([lat, lng]).addTo(map);
        @else
        var marker
        @endif

        // افزودن باکس جستجو به نقشه
        var geocoder = L.Control.Geocoder.nominatim();
        var control = L.Control.geocoder({
            geocoder: geocoder
        }).addTo(map);

        control.on('markgeocode', function(e) {
            var lat = e.geocode.center.lat;
            var lng = e.geocode.center.lng;

            // حذف مارکر قدیمی اگر وجود داشت
            if (marker) {
                map.removeLayer(marker);
            }

            // افزودن مارکر جدید به نقطه جستجو شده
            marker = L.marker([lat, lng]).addTo(map);
            map.setView([lat, lng], 7); // زوم به نقطه جستجو شده

            // قرار دادن مختصات در inputها
            document.getElementById('latitude').value = lat;
            document.getElementById('longitude').value = lng;
        });

        // رویداد کلیک روی نقشه
        map.on('click', function(e) {
            var lat = e.latlng.lat;
            var lng = e.latlng.lng;

            // حذف مارکر قدیمی اگر وجود داشت
            if (marker) {
                map.removeLayer(marker);
            }

            // افزودن مارکر جدید به نقطه کلیک شده
            marker = L.marker([lat, lng]).addTo(map);

            // قرار دادن مختصات در inputها
            document.getElementById('latitude').value = lat;
            document.getElementById('longitude').value = lng;
        });

        // رویداد کلیک روی دکمه "مکان‌یابی من"
        document.getElementById('locateBtn').addEventListener('click', function() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    var lat = position.coords.latitude;
                    var lng = position.coords.longitude;

                    // حذف مارکر قبلی اگر وجود دارد
                    if (marker) {
                        map.removeLayer(marker);
                    }

                    // اضافه کردن مارکر به مکان فعلی کاربر
                    marker = L.marker([lat, lng]).addTo(map);
                    map.setView([lat, lng], 14); // زوم به مکان کاربر

                    // قرار دادن مختصات مکان فعلی کاربر در inputها
                    document.getElementById('latitude').value = lat;
                    document.getElementById('longitude').value = lng;
                }, function(error) {
                    alert('Not Found Location 1');
                });
            } else {
                alert('Not Found Location 2');
            }
        });
    </script>
@endsection


