@extends('admin.layouts.app',['file_upload'=>true,'req'=>true,'editor'=>true])

@section('content')
    <style>
        .select2-results,
        .select2-container
        {
            direction: ltr;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-lg-12">
                        <div class="tab-menu-heading hremp-tabs p-0">
                            <div class="tabs-menu1">
                                <!-- Tabs -->
                                @include('admin.setting.profile.include.tab',['active'=>2])
                            </div>
                        </div>
                        <div class="panel-body tabs-menu-body hremp-tabs1 p-0">
                            @can('profile_edit')
                                <div class="card-body">
                                    {{ Form::model($item,array('route' => array('admin.profile.update'), 'method' => 'PATCH','id'=>'form_req','files'=>true)) }}
                                    {{Form::hidden('id', $item->id)}}
                                    <div class="row">
                                        <div class="col-md-4 {{auth()->user()->hasRole('buyer') ? '' : 'd-none'}}">
                                            <div class="form-group">
                                                {{Form::label('user_type', translateText('Real/Legal',lang_admin()).' *')}}
                                                {{ Form::select('user_type', ['legal'=>translateText('Legal',lang_admin()),'real'=>translateText('Real',lang_admin())], null, array('class' => 'form-control select2-show-search')) }}
                                            </div>
                                        </div>
                                        <div class="col-12 {{auth()->user()->hasRole('buyer') ? '' : 'd-none'}}"></div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                {{Form::label('username', translateText('نام کاربری',lang_admin()).' *')}}
                                                {{Form::text('username', null, array('class' => 'form-control d-ltr text-left','required','readonly'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                {{Form::label('name', translateText(auth()->user()->hasRole(['supplier'])?'نام(شرکت/کارخانه)':'نام شما',lang_admin()).' *')}}
                                                {{Form::text('name', null, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-4 {{auth()->user()->hasRole('supplier') && $item->user_type == 'legal' ? '' : 'd-none'}}">
                                            <div class="form-group ">
                                                {{Form::label('industry_id', translateText(auth()->user()->hasRole('supplier') ? 'صنعت *' : 'صنعت',lang_admin()))}}
                                                {{ Form::select('industry_id', array_pluck($industries, 'title', 'id',['',translateText('انتخاب کنید',lang_admin())]), null, array('class' => 'form-control select2-show-search','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),auth()->user()->hasRole('supplier') ? 'required' : '')) }}
                                            </div>
                                        </div>
                                        <div class="col-md-4 {{auth()->user()->hasRole('supplier') && $item->user_type == 'legal' ? '' : 'd-none'}}">
                                            <div class="form-group ">
                                                {{Form::label('year_of_establishment', translateText('تاریخ تاسیس',lang_admin()).'*')}}
                                                {{Form::date('year_of_establishment', $item->year_of_establishment, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-4 user_type_legal {{auth()->user()->hasRole('buyer') && $item->user_type == 'legal' ? '' : 'd-none'}}">
                                            <div class="form-group">
                                                {{Form::label('company_name', translateText('نام شرکت',lang_admin()).' *')}}
                                                {{Form::text('company_name', null, array('class' => 'form-control','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-12"></div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                {{Form::label('mobile', translateText('شماره همراه',lang_admin()).' *')}}
                                                {{Form::number('mobile', null, array('class' => 'form-control d-ltr text-left','required'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                {{Form::label('country_code', translateText('کد کشور',lang_admin()).' *')}}
                                                {{Form::number('country_code', $code, array('class' => 'form-control d-ltr text-left','required'))}}
                                            </div>
                                        </div>
                                        @if(auth()->user()->hasRole('buyer') || auth()->user()->hasRole('supplier'))
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                {{Form::label('business_type_id', translateText(auth()->user()->hasRole('supplier') ? 'نوع کسب و کار *' : 'نوع کسب و کار',lang_admin()))}}
                                                {{ Form::select('business_type_id[]', array_pluck($business_type, 'title', 'id'), $selected_business, array('class' => 'form-control select2-show-search','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),auth()->user()->hasRole('supplier') ? 'required' : '','multiple')) }}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                {{Form::label('purchasing_frequency_id', translateText(auth()->user()->hasRole('supplier') ? 'فرکانس خرید *' : 'فرکانس خرید',lang_admin()))}}
                                                {{ Form::select('purchasing_frequency_id', array_pluck($purchasing_frequency, 'title', 'id',['',translateText('انتخاب کنید',lang_admin())]), null, array('class' => 'form-control select2-show-search','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),auth()->user()->hasRole('supplier') ? 'required' : '')) }}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                {{Form::label('annual_purchase_volume_id', translateText(auth()->user()->hasRole('supplier') ? 'حجم خرید سالانه *' : 'حجم خرید سالانه',lang_admin()))}}
                                                {{ Form::select('annual_purchase_volume_id', array_pluck($annual_purchase_volume, 'title', 'id',['',translateText('انتخاب کنید',lang_admin())]), null, array('class' => 'form-control select2-show-search','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),auth()->user()->hasRole('supplier') ? 'required' : '')) }}
                                            </div>
                                        </div>
                                        @endif
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                {{Form::label('info', translateText('درباره خودتان/شرکتتان بگویید',lang_admin()))}}
                                                {{Form::textarea('info', null, array('class' => 'form-control textarea_'.dir_admin()))}}
                                            </div>
                                            <p class="text-danger">_<small>{{translateText('شما میتوانید در باره خودتان، کارخانه، شرکت خود توصیف کنید',lang_admin())}}</small></p>
                                        </div>
                                        <div class="col-md-12"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                {{Form::label('password', translateText('رمز عبور',lang_admin()))}}
                                                {{Form::password('password', array('class' => 'form-control d-ltr text-left','autocomplete'=>'new-password'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                {{Form::label('password_confirmation', translateText('تکرار رمز عبور',lang_admin()))}}
                                                {{Form::password('password_confirmation', array('class' => 'form-control d-ltr text-left'))}}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group" id="photos">
                                                {{Form::label('photo',translateText(auth()->user()->hasRole('supplier') ? 'لوگو' : 'تصویر پروفایل',lang_admin()))}}
                                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                                            </div>
                                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 256KB می باشد',lang_admin())}}</small></p>
                                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 300 پیکسل در ارتفاع 300 پیکسل می باشد',lang_admin())}}</small></p>
                                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                                        </div>
                                        @if(auth()->user()->hasRole('supplier'))
                                        <div class="col-md-6">
                                            <div class="form-group" id="photos">
                                                {{Form::label('header_profile',translateText('تصویر واید هدر پروفایل',lang_admin()))}}
                                                {{Form::file('header_profile', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $item->header_profile ? $item->header_profile->id : 0,'data-default-file'=>$item->header_profile && is_file($item->header_profile->path)?url($item->header_profile->path):null))}}
                                            </div>
                                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 1400 پیکسل در ارتفاع 250 پیکسل می باشد',lang_admin())}}</small></p>
                                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                                        </div>
                                        @endif
                                        <div class="col-md-12 text-left">
                                            <hr/>
                                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                                        </div>
                                    </div>
                                    {!! Form::close() !!}
                                </div>
                            @endcan
                        </div>
                    </div>
                </div>
                <!-- End Row-->
            </div>
        </div>
    </div>
@endsection
@section('in_tag_script')
    <script>
        $('#user_type').on('change',function (){
            var type=$(this).val()
            if(type === 'legal')
            {
                $('.user_type_legal').removeClass('d-none')
                $('#company_name').prop('required',true)
            }
            else
            {
                $('.user_type_legal').addClass('d-none')
                $('#company_name').prop('required',false)
            }
        })
    </script>
@endsection


