@extends('admin.layouts.app',['file_upload'=>true])

@section('content')
    <style>
        .accordion button {
            text-align: start;
        }

        .text-end {
            text-align: end;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-lg-12">
                        <div class="tab-menu-heading hremp-tabs p-0">
                            <div class="tabs-menu1">
                                <!-- Tabs -->
                                @include('admin.setting.profile.include.tab',['active'=>1])
                            </div>
                        </div>
                        <div class="panel-body tabs-menu-body hremp-tabs1 p-0">
                            <div class="card-body">
                                <div class="row">
                                    @if($item->employee && $item->employee->pic)
                                        <div class="col-md-12 text-center mb-5">
                                            <img src="{{url($item->employee->pic)}}"
                                                 style="height: 150px;object-fit: contain"
                                                 alt="{{$item->name}}">
                                        </div>
                                    @endif
                                    <div class="col-md-12">
                                        <p>
                                            <strong>     {{translateText('نام',lang_admin())}} : </strong>
                                            <span>{{$item->name?$item->name:'ثبت نشده'}}</span>
                                        </p>
                                        <hr/>
                                    </div>
                                    <div class="col-md-12">
                                        <p>
                                            <strong>     {{translateText('نام کاربری/ایمیل',lang_admin())}} : </strong>
                                            <span dir="{{$item->username?'ltr':''}}">{{$item->username?$item->username:'ثبت نشده'}}</span>
                                        </p>
                                        <hr/>
                                    </div>
                                    <div class="col-md-12">
                                        <p>
                                            <strong>     {{translateText('شماره همراه',lang_admin())}} : </strong>
                                            <span dir="{{$item->mobile?'ltr':''}}">{{$item->mobile?$item->country_code.' '.$item->mobile:'ثبت نشده'}}</span>
                                        </p>
                                        <hr/>
                                    </div>
                                    <div class="col-md-12">
                                        <p>
                                            <strong>     {{translateText('وضعیت پنل',lang_admin())}} : </strong>
                                            <span>{!! status($item->status) !!}
                                                @if($item->status=='blocked' && $item->info_blocked)
                                                    ({{$item->info_blocked}})
                                                @endif
                                                        </span>
                                        </p>
                                        <hr/>
                                    </div>
                                    @if(auth()->user()->hasRole(['buyer','supplier']))
                                        <div class="col-md-12">
                                            <p>
                                                <strong>     {{translateText('وضعیت تاییدیه',lang_admin())}} : </strong>
                                                <span>{!! status($item->status_verify) !!}</span>
                                            </p>
                                            <hr/>
                                        </div>
                                    @endif
                                    @if(auth()->user()->hasRole('supplier'))
                                        @if($package)
                                            <div class="col-md-12">
                                                <p>
                                                    <strong>     {{translateText('پکیج فعال',lang_admin())}} : </strong>
                                                    <span class="badge badge-success" dir="ltr">{{$verify->verify_type}} - {{\Carbon\Carbon::parse($verify->verify_date)->format('Y-m-d')}}</span>
                                                    <span class="badge badge-success" dir="ltr">{{translateText('اعتبار',lang_admin())}}: {{$days}} {{translateText('روز',lang_admin())}}</span>
                                                </p>
                                                <hr/>
                                            </div>
                                        @else
                                            <div class="col-md-12">
                                                <p>
                                                    <strong>     {{translateText('پکیج فعال',lang_admin())}} : </strong>
                                                    <span class="badge badge-danger"> {{translateText('ندارید',lang_admin())}}</span>
                                                </p>
                                                <hr/>
                                            </div>
                                        @endif
                                        @if((int)$days < 10)
                                            <h5>{{translateText('تمدید/خرید پکیج',lang_admin())}}</h5>
                                            <div class="accordion w-100" id="accordionExample">
                                                @foreach($packages as $key=>$pack)
                                                    <div class="card mb-1">
                                                        <div class="card-header p-0" id="heading{{$key}}">
                                                            <button class="btn btn-default btn-block py-3 {{$key > 0 ? 'collapsed' : ''}}"
                                                                    type="button" data-toggle="collapse"
                                                                    data-target="#collapse{{$key}}" aria-expanded="true"
                                                                    aria-controls="collapse{{$key}}">
                                                                {{read_lang($pack,'title')}}
                                                                - {{number_format($pack->price,2,'.')}} TL
                                                            </button>
                                                        </div>

                                                        <div id="collapse{{$key}}"
                                                             class="collapse {{$key == 0 ? 'show' : ''}}"
                                                             aria-labelledby="heading{{$key}}"
                                                             data-parent="#accordionExample">
                                                            <div class="card-body">
                                                                <div class="text-end mb-4">
                                                                    <a href="{{route('admin.profile.package.sale',$pack->id)}}"
                                                                       class="btn btn-success">{{translateText('پرداخت',lang_admin())}} {{number_format($pack->price,2,'.')}}
                                                                        TL</a>
                                                                </div>
                                                                {!!read_lang($pack,'text')!!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Row-->
            </div>
        </div>
    </div>
@endsection()


