@extends('admin.layouts.app',['req'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.redirect.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    @if($type == 410)
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('title', translateText('عنوان',lang_admin()).' *')}}
                                    {{Form::text('title', null, array('class' => 'form-control','required'))}}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('status', translateText('وضعیت',lang_admin()).' *')}}
                                    {{ Form::select('status', ['active'=>translateText('انتشار',lang_admin()),'pending'=>translateText('عدم انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('type', translateText('روش',lang_admin()).' *')}}
                                    {{ Form::select('type', [410=>410,404=>404], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('from', translateText('لینک',lang_admin()).' *')}}
                                    {{Form::url('from', null, array('class' => 'form-control d-ltr text-left'))}}
                                </div>
                            </div>

                            <div class="col-md-12 text-left">
                                <hr/>
                                {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                            </div>
                        </div>
                    @elseif($type == 301)
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('title', translateText('عنوان',lang_admin()).' *')}}
                                    {{Form::text('title', null, array('class' => 'form-control','required'))}}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('status', translateText('وضعیت',lang_admin()).' *')}}
                                    {{ Form::select('status', ['active'=>translateText('انتشار',lang_admin()),'pending'=>translateText('عدم انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('type', translateText('روش',lang_admin()).' *')}}
                                    {{ Form::select('type', [301=>301,302=>302], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('groups', translateText('گروهی',lang_admin()).' *')}}
                                    {{ Form::select('groups', ['no'=>translateText('خیر',lang_admin()),'yes'=>translateText('بلی',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                    <p class="text-danger mt-0 mb-3" style="font-size: 12px"><small>_</small>{{translateText('فقط در روش 301 اعمال می شود',lang_admin())}}</p>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('from', translateText('از لینک',lang_admin()).' *')}}
                                    {{Form::url('from', null, array('class' => 'form-control d-ltr text-left'))}}
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('to', translateText('به لینک',lang_admin()).' *')}}
                                    {{Form::url('to', null, array('class' => 'form-control d-ltr text-left'))}}
                                </div>
                            </div>

                            <div class="col-md-12 text-left">
                                <hr/>
                                {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                            </div>
                        </div>
                    @endif

                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>


@endsection
