@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('redirect_create')
                            <a href="{{route('admin.redirect.create',['type'=>410])}}"
                               class="btn btn-primary mx-1 float-left">افزودن 410</a>
                            <a href="{{route('admin.redirect.create')}}" class="btn btn-primary mx-1 float-left">افزودن
                                ریدایرکت</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('عنوان',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('نوع',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('لینک',lang_admin())}}</th>
                                @can('redirect_status')
                                    <th class="border-bottom-0">{{translateText('وضعیت',lang_admin())}}</th>
                                @endcan
                                <th class="border-bottom-0">{{translateText('گزارش',lang_admin())}}</th>
                                @canany(['redirect_edit','redirect_delete'])
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$item->title}}</td>
                                    <td>
                                        {{$item->type}}
                                        @if($item->type == 301 && $item->groups == 'yes')
                                            <span class="badge badge-info">{{translateText('گروهی',lang_admin())}}</span>
                                        @endif
                                    </td>
                                    <td dir="ltr" class="text-left">
                                        <a href="{{$item->from}}" target="_blank">
                                            {{urldecode($item->from)}}
                                        </a>
                                        @if($item->to)
                                            <br/>
                                            <a href="{{$item->to}}" target="_blank">
                                                {{urldecode($item->to)}}
                                            </a>
                                        @endif
                                    </td>
                                    @can('redirect_status')
                                        <td>
                                            @if($item->status=='active')
                                                <span class="text-success ml-2">{{translateText('فعال',lang_admin())}}</span>
                                                <a href="{{route('admin.redirect.status',[$item->id,'pending'])}}">
                                                    <i class="fa fa-close text-danger"></i>
                                                </a>
                                            @else
                                                <span class="text-danger ml-2">{{translateText('غیرفعال',lang_admin())}}</span>
                                                <a href="{{route('admin.redirect.status',[$item->id,'active'])}}">
                                                    <i class="fa fa-check text-success"></i>
                                                </a>
                                            @endif
                                        </td>
                                    @endcan
                                    <td>
                                        {{translateText('افزودن',lang_admin())}}: {{$item->user_create?$item->user_create->name:$item->user_id_create}}
                                        @if(!blank($item->user_id_edit))
                                            <br/>
                                            {{translateText('ویرایش',lang_admin())}}: {{$item->user_edit?$item->user_edit->name:$item->user_id_edit}}
                                        @endif
                                    </td>
                                    @canany(['redirect_edit','redirect_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('redirect_edit')
                                                    <a href="{{route('admin.redirect.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                @can('redirect_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.redirect.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
