@extends('admin.layouts.app',['tbl'=>true])

@section('content')
<style>
    .box_sh
    {
        box-shadow:0 0 2px 0 #66666650;
        border-radius:3px;
    }
    .box_sh label
    {
        font-size: 12px;
    }
</style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('عنوان',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('مبلغ',lang_admin())}}</th>
{{--                                <th class="border-bottom-0">{{translateText('تصویر',lang_admin())}}</th>--}}
                                @can('setting_sale_edit')
                                <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                    @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        {{$item->title}}
                                        <span class="badge badge-danger">{{$item->role}}</span>
                                    </td>
                                    <td>
                                        {{number_format($item->price,2,'.')}} TL
                                    </td>
{{--                                    <td>--}}
{{--                                        @if($item->photo && is_file($item->photo->path))--}}
{{--                                            <img src="{{url($item->photo->path)}}" height="100px">--}}
{{--                                        @else--}}
{{--                                            __--}}
{{--                                        @endif--}}
{{--                                    </td>--}}
                                    @can('setting_sale_edit')
                                    <td>
                                        <div class="d-flex">
                                            <a href="{{route('admin.setting-sale.edit',$item->id)}}"
                                               class="action-btns1">
                                                <i class="feather feather-edit-2  text-success"
                                                   data-toggle="tooltip" data-placement="top"
                                                   title="{{translateText('ویرایش',lang_admin())}}"></i>
                                            </a>
                                        </div>
                                    </td>
                                        @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
