@extends('admin.layouts.app', ['tbl' => true,'file_upload'=>true])

@section('content')
    <style>
        .w-100 {
            width: 100%;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <div class="card-body">
                    <div class="row py-5">
                        <div class="table-responsive">
                            <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                                <thead>
                                <tr>
                                    <th class="border-bottom-0">#</th>
                                    <th class="border-bottom-0">{{translateText('فایل فعلی',lang_admin())}}</th>
                                    @canany(['upload_sitemap_edit'])
                                        <th class="border-bottom-0">{{translateText('بروزرسانی',lang_admin())}}</th>
                                    @endcan
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($items as $key => $item)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td><a href="{{url($item->file)}}" target="_blank">{{translateText('دانلود',lang_admin())}}</a></td>
                                        @can('upload_sitemap_edit')
                                            <td>
                                                {!! Form::model($item,['method' => 'PATCH', 'route' => ['admin.upload-sitemaps.update', $item->id],'id' => 'form_req', 'files' => true]) !!}
                                                <input type="file" name="file" class="file-browserinput p-3"
                                                       accept=".xml"
                                                       onchange="return this.form.submit()">
                                                {!! Form::close() !!}
                                            </td>
                                        @endcan
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@endsection
@section('script')

@endsection
