<!-- Modal -->
<div class="modal fade" id="certificateModal{{$item->id}}" tabindex="-1" role="dialog"  aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{translateText('مجوزها/گواهینامه',lang_admin())}}  {{$item->name}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            <p>
                                <strong>{{translateText('نام',lang_admin())}} : </strong>
                                <span>{{$item->name?$item->name:'__'}}</span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong>{{translateText('نام کاربری/ایمیل',lang_admin())}} : </strong>
                                <span dir="{{$item->username?'ltr':'rtl'}}">{{$item->username?$item->username:'__'}}</span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong>{{translateText('شماره همراه',lang_admin())}} : </strong>
                                <span dir="{{$item->mobile?'ltr':'rtl'}}">{{$item->mobile?$item->country_code.'-'.$item->mobile:'__'}}</span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-12">
                            <p>
                                <strong>{{translateText('نوع کسب وکار',lang_admin())}} : </strong>
                                @if(count($item->user_business))
                                    <span>
                                                                                                @foreach($item->user_business as $key=>$business)
                                            {{$key > 0 ? ', ':''}}
                                            {{$business->title}}
                                        @endforeach
                                                                                            </span>
                                @else
                                    <span>__</span>
                                @endif
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong>{{translateText('فرکانس خرید',lang_admin())}} : </strong>
                                <span>{{$item->user_purchasing?$item->user_purchasing->title:'__'}}</span>
                            </p>
                            <hr/>
                        </div>
                        <div class="col-md-6">
                            <p>
                                <strong>{{translateText('حجم خرید سالیانه',lang_admin())}} : </strong>
                                <span>{{$item->user_volume?$item->user_volume->title:'__'}}</span>
                            </p>
                            <hr/>
                        </div>
                        @if($item->hasRole('supplier'))
                        <div class="col-12" style="overflow-x: auto">
                            <p>
                                <strong>{{translateText('آدرس',lang_admin())}}: </strong>
                            </p>
                            @if(count($item->addresses))
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{translateText('نام(شرکت/کارخانه)',lang_admin())}}</th>
                                        <th>{{translateText('تماس',lang_admin())}}</th>
                                        <th>{{translateText('کشور',lang_admin())}}</th>
                                        <th>{{translateText('آدرس',lang_admin())}}</th>
                                        <th>Zip Code</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($item->addresses as $key=>$address)
                                        <tr>
                                            <th scope="row">{{$key + 1}}</th>
                                            <td>{{$address->full_name}}</td>
                                            <td dir="ltr">
                                                {{translateText('Phone:',lang_admin())}}
                                                <span dir="ltr"
                                                      class="text-danger">{{$address->phone}}</span>
                                                <br>
                                                {{translateText('Fax:',lang_admin())}}
                                                <span dir="ltr" class="text-danger">{{$address->fax}}</span>
                                                <br>
                                                {{translateText('Mobile:',lang_admin())}}
                                                <span dir="ltr"
                                                      class="text-danger">{{$address->mobile}}</span>
                                                <br>
                                                {{translateText('Email:',lang_admin())}}
                                                <span dir="ltr"
                                                      class="text-danger">{{$address->email}}</span>
                                            </td>
                                            <td>{{$address->country ? $address->country->nicename : '__'}}</td>
                                            <td>
                                                {{$address->state}}/{{$address->city}}
                                                <br/>
                                                {{$address->address}}
                                            </td>
                                            <td>{{$address->zip_code}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            @else
                                <div class="alert alert-danger col-12 py-3">
                                    {{translateText('آدرسی ثبت نشده',lang_admin())}}
                                </div>
                            @endif
                            <hr/>
                        </div>
                        @endif
                        @if($item->user_type == 'legal')
                        <div class="col-12" style="overflow-x: auto">
                            <p>
                                <strong>{{translateText('گواهینامه ها',lang_admin())}} : </strong>
                            </p>
                            @if(count($item->certificates))
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{translateText('نوع سند',lang_admin())}}</th>
                                        <th>{{translateText('نوع گواهینامه',lang_admin())}}</th>
                                        <th>Tax Id/License Id</th>
                                        <th>{{translateText('تصویر',lang_admin())}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($item->certificates as $key=>$certificate)
                                        <tr>
                                            <th scope="row">{{$key + 1}}</th>
                                            <td>{{$certificate->get_type_title()}}</td>
                                            <td>{{$certificate->select_type ? $certificate->select_type->title : '__'}}</td>
                                            <td>{{!blank($certificate->tax_id) ? $certificate->tax_id : '__'}}</td>
                                            <td>
                                                @if($certificate->photo)
                                                    <a href="{{url($certificate->photo->path)}}"
                                                       target="_blank">
                                                        Show
                                                    </a>
                                                @else
                                                    __
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            @else
                                <div class="alert alert-danger col-12 py-3">
                                    {{translateText('گواهینامه ای ثبت نشده',lang_admin())}}
                                </div>
                            @endif
                            <hr/>
                        </div>
                        @endif
                        @if($item->hasRole('buyer'))
                        <div class="col-12" style="overflow-x: auto">
                            <p>
                                <strong>{{translateText('Passport',lang_admin())}} : </strong>
                            </p>
                            @if($item->passport)
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>{{translateText('Passport Number',lang_admin())}}</th>
                                        <th>{{translateText('تصویر',lang_admin())}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{$item->passport->tax_id}}</td>
                                            <td>
                                                @if($item->passport->photo)
                                                    <a href="{{url($item->passport->photo->path)}}"
                                                       target="_blank">
                                                        Show
                                                    </a>
                                                @else
                                                    __
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            @else
                                <div class="alert alert-danger col-12 py-3">
                                    {{translateText('گذرنامه ای ثبت نشده',lang_admin())}}
                                </div>
                            @endif
                            <hr/>
                        </div>
                            <div class="col-12" style="overflow-x: auto">
                                <p>
                                    <strong>{{translateText('National ID Card',lang_admin())}} : </strong>
                                </p>
                                @if($item->n_cart)
                                    <table class="table table-striped w-100">
                                        <thead>
                                        <tr>
                                            <th>{{translateText('National ID Card Number',lang_admin())}}</th>
                                            <th>{{translateText('تصویر',lang_admin())}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>{{$item->n_cart->tax_id}}</td>
                                            <td>
                                                @if($item->n_cart->photo)
                                                    <a href="{{url($item->n_cart->photo->path)}}"
                                                       target="_blank">
                                                        Show
                                                    </a>
                                                @else
                                                    __
                                                @endif
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                @else
                                    <div class="alert alert-danger col-12 py-3">
                                        {{translateText('گذرنامه ای ثبت نشده',lang_admin())}}
                                    </div>
                                @endif
                                <hr/>
                            </div>
                        @endif
                        @if(count($item->gallery))
                            <div class="col-12" style="overflow-x: auto">
                                <p>
                                    <strong>{{translateText('گالری تصایر/ویدئو',lang_admin())}} : </strong>
                                </p>
                                <table class="table table-striped w-100">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{translateText('عنوان گالری',lang_admin())}}</th>
                                        <th>{{translateText('تصاویر/ویدئو',lang_admin())}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($item->gallery as $key=>$gallery)
                                        <tr>
                                            <th scope="row">{{$key + 1}}</th>
                                            <td>{{$gallery->title}}</td>
                                            <td>
                                                @if($gallery->photo)
                                                    <a href="{{url($gallery->photo->path)}}" data-fancybox="gallery_{{$gallery->id}}_{{$item->id}}">
                                                        <img src="{{url($gallery->photo->path)}}" height="100px">
                                                    </a>
                                                    @foreach($gallery->galleries as $photo)
                                                        <a href="{{url($photo->file)}}" class="d-none" data-fancybox="gallery_{{$gallery->id}}_{{$item->id}}"></a>
                                                    @endforeach
                                                @else
                                                    @foreach($gallery->galleries as $keyy=>$photo)
                                                        <a href="{{url($photo->file)}}" class="{{$keyy > 0 ? 'd-none' : ''}}" data-fancybox="gallery_{{$gallery->id}}_{{$item->id}}">نمایش گالری</a>
                                                    @endforeach
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <hr/>
                            </div>
                        @endif
                        <div class="col-12">
                            {!! $item->info !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>