@extends('admin.layouts.app',['tbl'=>true])

@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}">
    <style>
        .fancybox__container {
            z-index: 99999;
        }

        table * {
            /*font-size: 13px;*/
        }

        table.dataTable tbody td, table.dataTable thead td {
            padding: 6px !important;
            vertical-align: middle;
        }

        table.dataTable tbody th, table.dataTable thead th {
            padding: 10px 6px !important;
            /*font-size: 13px!important;*/
        }
    </style>
@endsection
@section('content')

    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @if(!isset(request()->role))
                            @can('user_create')
                                <a href="{{route('admin.user.create')}}"
                                   class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                            @endcan
                        @endif
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('نام',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('دسترسی',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('نام کاربری',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('شماره همراه',lang_admin())}}</th>
                                @can('user_status')
                                    <th class="border-bottom-0">{{translateText('وضعیت',lang_admin())}}</th>
                                @endcan
                                @canany(['user_edit','user_delete','user_access','user_fast_login'])
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        {{$item->name}}
                                    </td>
                                    <td dir="ltr">
                                        {{$item->roles->first()->title}}
                                    </td>
                                    <td dir="ltr">
                                        {{$item->username}}
                                    </td>
                                    <td dir="{{$item->mobile?'ltr':''}}">
                                        {{$item->mobile?$item->country_code.' '.$item->mobile:'__'}}
                                    </td>
                                    @can('user_status')
                                        <td>
                                            {{translateText('وضعیت',lang_admin())}}:
                                            @if($item->status=='active')
                                                <span class="text-success ml-1">{{translateText('فعال',lang_admin())}}</span>
                                                <a href="{{route('admin.user.status',[$item->id,'status','blocked'])}}">
                                                    <i class="fa fa-close text-danger"></i>
                                                </a>
                                            @else
                                                <span class="text-danger ml-1">{{translateText('مسدود',lang_admin())}}</span>
                                                <a href="{{route('admin.user.status',[$item->id,'status','active'])}}">
                                                    <i class="fa fa-check text-success"></i>
                                                </a>
                                            @endif
                                            @if($item->hasRole(['buyer', 'supplier']))
                                                <br/>
                                                {{translateText('Verify',lang_admin())}}:
                                                @if($item->status_verify=='active')
                                                    <span class="text-success ml-1">{{translateText('فعال',lang_admin())}}</span>
                                                    <a href="{{route('admin.user.status',[$item->id,'status_verify','blocked'])}}">
                                                        <i class="fa fa-close text-danger"></i>
                                                    </a>
                                                @else
                                                    <span class="text-danger ml-1">{{translateText('غیرفعال',lang_admin())}}</span>
                                                    <a href="{{route('admin.user.status',[$item->id,'status_verify','active'])}}">
                                                        <i class="fa fa-check text-success"></i>
                                                    </a>
                                                @endif
                                            @endif
                                        </td>
                                    @endcan
                                    @canany(['user_edit','user_delete','user_access','user_fast_login'])
                                        <td>
                                            <div class="d-flex">
                                                @can('user_status')
                                                    @if($item->hasRole(['buyer', 'supplier']))
                                                        <a href="javascript:void(0)" target="_blank"
                                                           class="action-btns1" data-toggle="modal"
                                                           data-target="#certificateModal{{$item->id}}">
                                                            <i class="fa fa-certificate text-primary"
                                                               data-toggle="tooltip" data-placement="top"
                                                               title="{{translateText('مجوزها(اطلاعات بیشتر)',lang_admin())}}"></i>
                                                        </a>

                                                        @include('admin.user.include.modal')
                                                    @endif
                                                @endcan
                                                @can('user_fast_login')
                                                    <a href="{{route('admin.user.fast.login',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="fa fa-sign-in text-dark"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ورود به پنل کاربر',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                @can('user_access')
                                                    <a href="{{route('admin.user.edit.permission',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-lock  text-info"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('مجوزها',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                    @if(!isset(request()->role))
                                                @can('user_edit')
                                                    <a href="{{route('admin.user.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan

                                                @can('user_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.user.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top"
                                                            title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                @endcan
                                                        @endif
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('in_tag_script')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
@endsection
