@extends('front.layouts.front')
@section('styles')
    <style>
        .app-content {
            margin-right: unset !important;
            margin-top: 20px !important;
        }

        footer.footer {
            padding: unset;
        }

        .bg_image {
            background: url('{{login_bg()}}');
            background-repeat: no-repeat;
            background-size: cover;
        }

        .gmail_icon {
            width: 60px;
        }
    </style>
@endsection
@section('body')
    <div class="py-5 bg_image">
        <div class="container">
            <div class="row justify-content-end">
                <div class="col-lg-4 col-md-6">
                    <div class="card">
                        <div class="card-header">{{read_lang_word('login-title')}}</div>

                        <div class="card-body">
                            <form method="POST" action="{{ route('login') }}">
                                @csrf

                                <div class="form-group">
                                    <label for="email"
                                           class="col-form-label py-0">{{read_lang_word('login-email')}}</label>
                                    <input id="username" type="text"
                                           class="form-control d-ltr text-left @error('username') is-invalid @enderror"
                                           name="username" value="{{ old('username') }}" required
                                           autocomplete="username" autofocus>
                                    @error('username')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="form-group mt-3">
                                    <label for="password"
                                           class="col-form-label py-0">{{read_lang_word('login-password')}}</label>
                                    <input id="password" type="password"
                                           class="form-control d-ltr text-left @error('password') is-invalid @enderror"
                                           name="password" required autocomplete="current-password">

                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>


                                <div class="form-group mt-3">
                                    @if (Route::has('password.request'))
                                        <a class="py-2 d-block w-100" href="">
                                            {{read_lang_word('login-forget-password')}}
                                        </a>
                                    @endif
                                    <button type="submit" class="btn btn-primary w-100">
                                        {{read_lang_word('login-btn')}}
                                    </button>
                                    <a class="btn btn-secondary mt-2 w-100" href="{{route('register')}}">
                                        {{read_lang_word('login-register')}}
                                    </a>
                                </div>
                                <div class="form-group mt-3 text-center">
                                    <a class="mt-2 w-100 mx-2" href="{{route('front.redirectToGoogle')}}"
                                            {{--                               target="popup" onclick="window.open('{{route('front.redirectToGoogle')}}','popup','width=600,height=600'); return false;"--}}
                                    >
                                        {!! icon_svg('gmail') !!}
                                        {{read_lang_word('login-gmail')}}
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
