@if ($paginator->hasPages())
    <nav class="d-inline-block">
        <ul class="pagination">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="page-item disabled"><span class="page-link">«</span></li>
            @else
                <li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">«</a></li>
            @endif

            {{-- First Page Link --}}
            @if($paginator->currentPage() > 3)
                <li class="page-item"><a class="page-link" href="{{ $paginator->url(1) }}">1</a></li>
            @endif

            {{-- Ellipsis for gaps before current page --}}
            @if($paginator->currentPage() > 4)
                <li class="page-item"><span class="page-link">...</span></li>
            @endif

            {{-- Pages around current page --}}
            @foreach(range(1, $paginator->lastPage()) as $i)
                @if($i >= $paginator->currentPage() - 2 && $i <= $paginator->currentPage() + 2)
                    @if ($i == $paginator->currentPage())
                        <li class="active page-item"><span class="page-link">{{ $i }}</span></li>
                    @else
                        <li class="page-item"><a class="page-link" href="{{ $paginator->url($i) }}">{{ $i }}</a></li>
                    @endif
                @endif
            @endforeach

            {{-- Ellipsis for gaps after current page --}}
            @if($paginator->currentPage() < $paginator->lastPage() - 3)
                <li class="page-item"><span class="page-link">...</span></li>
            @endif

            {{-- Last Page Link --}}
            @if($paginator->currentPage() < $paginator->lastPage() - 2)
                <li class="page-item"><a class="page-link" href="{{ $paginator->url($paginator->lastPage()) }}">{{ $paginator->lastPage() }}</a></li>
            @endif

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="page-item"><a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">»</a></li>
            @else
                <li class="disabled page-item"><span class="page-link">»</span></li>
            @endif
        </ul>
    </nav>
@endif