@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
  <!--about section start-->
  <section class="about-section pt-50 pb-50 bg-white">
    <span class="small-circle-shape position-absolute z--1"></span>
    <div class="container">
      <div class="row align-items-center">
        <div class="col-xl-12">
          <h2 class="text-center mb-0">{{read_lang($item,'title')}}</h2>
          <hr class="my-3 editor-text"/>
              {!! read_lang($item,'text') !!}
        </div>
        <div class="col-xl-8 col-lg-9 col-md-10 mx-auto">
            <img src="{{$item->photo && is_file($item->photo->path)?url($item->photo->path):url('assets/front/img/home1/car-red.png')}}"
                 alt="{{photo_alt($item,'photo',read_lang($item,'title'))}}" class="img-fluid">
        </div>
      </div>
      <div class="row align-items-center mt-4">
        <div class="col-xl-12 mb-3">
          <h2 class="text-center mb-0">{{read_lang($item,'title1')}}</h2>
          <hr class="my-3 editor-text"/>
              {!! read_lang($item,'text1') !!}
        </div>
        @foreach($items_m as $item_m)
          <div class="col-md-3 col-sm-6 px-1 py2">
            <div class="card_about_mission">
              <div class="img_card">
                <img src="{{$item_m->photo ? url($item_m->photo->path) : url('assets/front/img/home1/blog-1.jpg')}}" alt="{{photo_alt($item_m,'photo',read_lang($item_m,'title'))}}">
              </div>
              <div class="text_card">
                <p class="text-center">{{$item_m->text}}</p>
              </div>
            </div>
          </div>
        @endforeach
      </div>
      <div class="row align-items-center mt-4">
        <div class="col-xl-12 mb-3">
          <h2 class="text-center mb-0">{{read_lang_word('our-work')}}</h2>
        </div>
        @foreach($items_w as $item_w)
          <div class="col-md-4 col-sm-6 py2">
              <article class="h4-ft-product-card">
                <figure class="p-2 feature-img position-relative overflow-hidden rounded-top mb-0 h-auto">
                  <a><img src="{{$item_w->photo && is_file($item_w->photo->path)?url($item_w->photo->path):url('assets/front/img/home1/blog-1.jpg')}}" alt="{{photo_alt($item_w,'photo',read_lang($item_w,'title'))}}" class="img-fluid service-img-fluid h-auto"></a>
                </figure>
                <div class="p-3">
                  <p>{{read_lang($item_w,'text')}}</p>
                </div>
              </article>
          </div>
        @endforeach
      </div>

      <div class="row align-items-center mt-4">
        <div class="col-xl-12 mb-3 editor-text">
          {!! read_lang($item,'text2') !!}
        </div>
      </div>

      <div class="row align-items-center mt-4">
        <div class="col-xl-12 mb-4">
          <h2 class="text-center mb-0">{{read_lang_word('corporate-publications')}}</h2>
        </div>
        @foreach($items_c as $item_c)
          <div class="col-md-6 py2">
            <div class="container-fluid">
              <div class="row">
                <div class="col-sm-6">
                  <img src="{{$item_c->photo && is_file($item_c->photo->path)?url($item_c->photo->path):url('assets/front/img/home1/blog-1.jpg')}}" alt="{{photo_alt($item_c,'photo',read_lang($item_c,'title'))}}" class="img-fluid w-100 h-220-px object-fit-contain">
                </div>
                <div class="col-sm-6 my-2">
                  <p class="rounded border px-2 py-3">{{read_lang($item_c,'text')}}</p>
                </div>
              </div>
            </div>
          </div>
        @endforeach
      </div>
    </div>

  </section>
  <!--about section end-->
@endsection
@section('scripts') @endsection
