@extends('front.layouts.front')
@if(!blank($item->photo && is_file($item->photo->path)))
@section('title_seo')
  <meta name="twitter:image" content="{{url($item->photo->path)}}"/>
  <meta property="og:image" content="{{url($item->photo->path)}}"/>
@endsection
@endif
@section('styles') @endsection
@section('body')
  <!--blog list section start-->
  <section class="blog-list-section ptb-120">
    <div class="container">
      <div class="row">
        <div class="col-xl-8">
          <div class="blog-single-area bg-white rounded">
            <div class="bs-blog-meta d-flex align-items-center justify-content-between">
              <a href="{{route('front.blog.list','news')}}" class="btn-meta fw-bold">{{$item->type=='article'?read_lang_word('article'):read_lang_word('news')}}</a>
              @if(app()->getLocale() == 'fa')
                <span class="date" dir="rtl">{{my_jdate($item->created_at,'d F Y')}}</span>
              @else
                <span class="date">{{Carbon\Carbon::parse($item->created_at)->toFormattedDateString()}}</span>
              @endif
            </div>
            <h3 class="blog-title mt-3">{{read_lang($item,'title')}}</h3>
            <div class="bs-blog-thumb position-relative mt-40 mb-4">
              <span class="btn-meta text-primary bg-white position-absolute z-2"><span class="{{dir_set()=='ltr'?'me-1':'ms-1'}}"><i class="fas fa-eye"></i></span>{{$item->seen}}
                <span class="{{dir_set()=='ltr'?'ms-2 me-1':'me-2 ms-1'}}"><i class="fas fa-user"></i></span>{{read_lang($item,'author')}}
              </span>
              <img src="{{$item->photo && is_file($item->photo->path)?url($item->photo->path):url('assets/front/img/blog/blog-list-1.jpg')}}" alt="{{photo_alt($item,'photo',read_lang($item,'title'))}}" class="img-fluid">
            </div>
            {!! read_lang($item,'text') !!}
           <hr class="mt-40 mb-40">
            <div class="tags-social d-flex align-items-center justify-content-between flex-wrap">
              @if(count($tags))
              <div class="tags-list">
                <span class="title text-secondary fw-bold {{dir_set()=='ltr'?'me-2':'ms-2'}}">{{read_lang_word('keywords')}}:</span>
                @foreach($tags as $key_word)
                <a href="{{route('front.tag.show',[$item->slug])}}">{{read_lang($key_word,'title')}}</a>
                @endforeach
              </div>
              @endif
              <div class="bs_social_share">
                <a href="https://www.facebook.com/sharer/sharer.php?u={{route('front.blog.show',[$item->slug])}}&t={{read_lang($item,'title')}}"><i class="fab fa-facebook-f"></i></a>
                <a href="whatsapp://send?text={{route('front.blog.show',[$item->slug])}} {{read_lang($item,'title')}}"><i class="fab fa-whatsapp"></i></a>
                <a href="https://twitter.com/share?text={{$item->title}}&url={{route('front.blog.show',[$item->slug])}}"><i class="fab fa-twitter"></i></a>
                <a href="https://telegram.me/share/url?url={{route('front.blog.show',[$item->slug])}}&text={{read_lang($item,'title')}}"><i class="fab fa-telegram"></i></a>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-4">
          <div class="blog-sidebar mt-60 mt-xl-0">
            <div class="sidebar-widget recent_post-widget bg-white widget-padding rounded">
              <div class="widget-top d-flex">
                <h5 class="mb-0 flex-shrink-0">{{read_lang_word('recent-blog')}}</h5>
                <span class="spacer align-self-end"></span>
              </div>
              <ul class="recent_posts_list mt-30">
                @foreach($items_last as $last)
                <li class="d-flex align-items-center">
                  <div class="thumb-wrapper">
                    <a href="{{route('front.blog.show',[$last->slug])}}"><img src="{{$last->photo && is_file($last->photo->path)?url($last->photo->path):url('assets/front/img/blog/recent-post-1.jpg')}}" alt="{{photo_alt($last,'photo',read_lang($last,'title'))}}" class="img-fluid"></a>
                  </div>
                  <div class="rp_content">
                    <a href="{{route('front.blog.show',[$last->slug])}}" class="mb-1">{{read_lang($last,'title')}}</a>
                    <span class="date">{{Carbon\Carbon::parse($last->created_at)->toFormattedDateString()}}</span>
                  </div>
                </li>
                @endforeach
              </ul>
            </div>
            <div class="sidebar-widget recent_post-widget bg-white widget-padding rounded mt-4">
              <div class="widget-top d-flex">
                <h5 class="mb-0 flex-shrink-0">{{read_lang_word('most-visited')}}</h5>
                <span class="spacer align-self-end"></span>
              </div>
              <ul class="recent_posts_list mt-30">
                @foreach($items_seen as $seen)
                  <li class="d-flex align-items-center">
                    <div class="thumb-wrapper">
                      <a href="{{route('front.blog.show',[$seen->slug])}}"><img src="{{$seen->photo && is_file($seen->photo->path)?url($seen->photo->path):url('assets/front/img/blog/recent-post-1.jpg')}}" alt="{{photo_alt($seen,'photo',read_lang($seen,'title'))}}" class="img-fluid"></a>
                    </div>
                    <div class="rp_content">
                      <a href="{{route('front.blog.show',[$last->slug])}}" class="mb-1">{{read_lang($seen,'title')}}</a>
                      <span class="date">{{Carbon\Carbon::parse($seen->created_at)->toFormattedDateString()}}</span>
                    </div>
                  </li>
                @endforeach
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!--blog list section end-->
@endsection
@section('scripts') @endsection
