@extends('front.layouts.front')
@section('styles')
@endsection
@section('body')
    <!--faq & app section start-->
    <section class="position-relative z-1 overflow-hidden">
        <img src="{{ url('assets/front/img/shapes/net-shape.png') }}" alt="net shape" class="position-absolute end-0 top-0 z--1">
        <img src="{{ url('assets/front/img/shapes/net-left.png') }}" alt="net shape" class="position-absolute start-0 bottom-0 z--1">
        <div class="faq-section pt-50 pb-50">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="faq-tabs mt-5 brands-filter">

                            <div class="row g-4">
                                <div class="col-xl-12">

                                    <div class="accordion theme-accordion" id="accordion_1">
                                        @foreach ($items as $key => $item)
                                            <div class="accordion-item">
                                                <div class="accordion-header">
                                                    <a href="#ac_{{ $item->id }}" class="accordion-button {{ $key > 0 ? 'collapsed' : '' }}" data-bs-toggle="collapse">{{ $key + 1 }}: {{ read_lang($item, 'question') }}</a>
                                                </div>
                                                <div class="accordion-collapse collapse {{ $key > 0 ? '' : 'show' }}" id="ac_{{ $item->id }}" data-bs-parent="#accordion_1">
                                                    <div class="accordion-body">
                                                        {!! read_lang($item, 'answer') !!}
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach

                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <!--faq & app section end-->
@endsection
@section('scripts')
@endsection
