<script src="{{asset('assets/front/js/vendors/jquery.min.js')}}"></script>
<script src="{{url('assets/front/new/js/bootstrap.bundle.js')}}" defer></script>
<script src="{{url('assets/front/new/js/plugin/swiperjs/swiper-bundler.js')}}" defer></script>
<script src="{{url('assets/front/new/js/slider.js')}}" type="module" defer></script>
<script src="{{url('assets/front/new/js/app.js')}}" defer></script>

<script src="{{url('assets/front/new/js/sweetalert2.min.js')}}"></script>
<script>
    
    document.addEventListener('DOMContentLoaded', function () {
        const searchTypeSelect = document.getElementById('searchType');
        const selectedCategoryInput = document.getElementById('selectedCategory');
        searchTypeSelect.addEventListener('change', function () {
            selectedCategoryInput.value = this.value;
        });
        selectedCategoryInput.value = searchTypeSelect.value;
    });

    // در فایل js جداگانه یا درون تگ script
    $(document).ready(function () {
        const searchSelectId = $('#searchSelectId');
        const searchInput = $('#searchInput');
        const suggestionsContainer = $('#suggestionsContainer');
        const searchType = $('#selectedCategory');

        console.log(searchType)
        // تابع برای هایلایت کردن متن جستجو
        function highlightText(text, query) {
            if (!query) return text;

            const regex = new RegExp(`(${escapeRegExp(query)})`, 'gi');
            return text.replace(regex, '<span class="search-key">$1</span>');
        }

        // فرار کردن کاراکترهای خاص برای Regex
        function escapeRegExp(string) {
            return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
        }

        searchInput.on('keyup', function () {
            const query = $(this).val();
            searchSelectId.val(0);
            if (query.length < 2) {
                suggestionsContainer.hide();
                return;
            }

            $.ajax({
                url: '{{ route("front.search.suggest") }}',
                method: 'GET',
                data: {query: query, type1: $('#selectedCategory').val()},
                success: function (response) {
                    if (response.length > 0) {
                        let suggestionsHtml = '';

                        response.forEach(item => {
                            console.log(item)
                            const highlightedText = highlightText(item.text, query);
                            
                            suggestionsHtml += `
                            <span class="suggestion-item" data-type="${item.type}" data-value="${item.value}" data-text="${item.text}">
                                ${highlightedText}
                            </span>
                        `;
                        });

                        suggestionsContainer.html(suggestionsHtml).show();
                    } else {
                        suggestionsContainer.hide();
                    }
                }
            });
        });

        // مدیریت کلیک روی پیشنهاد
        suggestionsContainer.on('click', '.suggestion-item', function () {
            const text = $(this).data('text');
            const type = $(this).data('type');
            const value = $(this).data('value');

            searchInput.val(text);
            searchSelectId.val(value);
            // searchType.val(type);

            // ارسال خودکار فرم
            $('#searchForm').submit();
        });

        // مخفی کردن پیشنهادات هنگام کلیک خارج
        $(document).on('click', function (e) {
            if (!$(e.target).closest('.search-container').length) {
                suggestionsContainer.hide();
            }
        });
    });
    $('#search_top_btn').click(function () {
        if ($('#search_top').hasClass('active_search')) {
            $(this).removeClass('close_search')
            $('#search_top').removeClass('active_search')
            $(this).find('.close-circle').addClass('d-none')
            $(this).find('.search-circle').removeClass('d-none')
        } else {
            $(this).addClass('close_search')
            $('#search_top').addClass('active_search')
            $(this).find('.close-circle').removeClass('d-none')
            $(this).find('.search-circle').addClass('d-none')
        }
    })
    @if(session()->has('err_message'))
    $(document).ready(function () {
        Swal.fire({
            title: "{{read_lang_word('unsuccessful')}}",
            text: "{{ session('err_message') }}",
            icon: "warning",
            timer: 6000,
            timerProgressBar: true,
        })
    });
    @endif
    @if(session()->has('flash_message'))
    $(document).ready(function () {
        Swal.fire({
            title: "{{read_lang_word('successful')}}",
            text: "{{ session('flash_message') }}",
            icon: "success",
            timer: 6000,
            timerProgressBar: true,
        })
    })
    ;@endif
    @if (count($errors) > 0)
    $(document).ready(function () {
        Swal.fire({
            title: "{{read_lang_word('unsuccessful')}}",
            icon: "warning",
            html:
                    @foreach ($errors->all() as $key => $error)
                        '<p class="text-right mt-2 ml-5" dir="rtl"> {{$key+1}} : ' +
                '{{ $error }}' +
                '</p>' +
                    @endforeach
                        '<p class="text-right mt-2 ml-5" dir="rtl">' +
                '</p>',
            timer: @if(count($errors)>3)parseInt('{{count($errors)}}') * 1500 @else 6000 @endif,
            timerProgressBar: true,
        })
    });
    @endif
</script>
<script src="{{ url('/source/vendor/livewire/livewire/dist/livewire.js') }}?id=df3a17f2" data-update-uri="{{url('livewire/update')}}" data-turbo-eval="false" data-csrf="{{ csrf_token() }}"></script>
@yield ('scripts')