<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Location</title>

    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css"/>
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css"/>
</head>
<body>
    <div id="map" style="height: 100vh;width: 100%"></div>

    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>
    <script>
        var lat = parseFloat({{(float)$latitude > 0 && (float)$longitude > 0 ? $latitude : 37.095 }});
        var lng = parseFloat({{(float)$latitude > 0 && (float)$longitude > 0 ? $longitude : 42.348 }});
        var map = L.map('map').setView([lat, lng], 7);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);
        @if((float)$latitude > 0 && (float)$longitude > 0)
        var marker = L.marker([lat, lng]).addTo(map);
        @else
        var marker
        @endif
    </script>
</body>
</html>