@extends('front.layouts.front')
@section('styles')
    <link rel="stylesheet" href="{{ url('assets/front/css/fancybox.css') }}">
@endsection
@section('body')

    <!--hero section start-->
    <section class="position-relative overflow-hidden">
        <div class="container py-4 bg-white section-one">
            <div class="row h-100">
                <div class="col-xl-3 col-lg-4 h-100 mt-5 mt-lg-0 order-lg-1 order-2">
                    <div class="blog-sidebar mt-xl-0">
                        <div class="sidebar-widget recent_post-widget rounded">
                            <div class="widget-top d-flex mb-3">
                                <h5 class="mb-0 flex-shrink-0">
                                    {!! icon_svg('category') !!}
                                    {{ read_lang_word('slider-title-1') }}
                                </h5>
                                <span class="spacer align-self-end"></span>
                            </div>
                            <ul>
                                @foreach ($cats->take(12) as $cat)
                                    <li>
                                        <a href="{{ route('front.product.list', $cat->slug) }}" class="fs-14 font-weight-bold cat_slider">
                                            <img src="{{ $cat->icon && is_file($cat->icon->path) ? url($cat->icon->path) : url('assets/front/cat_default.webp') }}" class="cat_icon_menu"
                                                alt="{{ photo_alt($cat, 'icon', read_lang($cat, 'title')) }}">
                                            {{ read_lang($cat, 'title') }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-12 h-100 order-lg-2 order-1">
                    <div class="swiper at-hero-slider-wrapper" data-speed="900">
                        <div class="swiper-wrapper h-100">
                            @if (count($sliders))
                                @foreach ($sliders as $slider)
                                    <div class="swiper-slide h-100">
                                        <div class="dl-hero-single h-100">
                                            <img src="{{ $slider->photo && is_file($slider->photo->path) ? url($slider->photo->path) : url('source/Slıder1.jpg') }}"
                                                @if ($slider->link != '#' || !blank($slider->link)) onclick="document.location = '{{ $slider->link }}'" @endif class="img-fluid-custom pointer" alt="{{ photo_alt($slider, 'photo', 'slider') }}">
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <div class="flash-controls flash1-button-prev flash-button-prev"><i class="fa-solid fa-angle-left"></i></div>
                        <div class="flash-controls flash1-button-next flash-button-next"><i class="fa-solid fa-angle-right"></i></div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 h-100 mt-5 mt-lg-0 order-lg-3 order-3">
                    <div class="hero-forms-section">
                        <ul class="nav nav-tabs" id="filterTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="suppliers-tab" data-bs-toggle="tab" data-bs-target="#suppliers" type="button" role="tab">
                                    {{ __('Suppliers') }}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="buyers-tab" data-bs-toggle="tab" data-bs-target="#buyers" type="button" role="tab">
                                    {{ __('Buyers') }}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="products-tab" data-bs-toggle="tab" data-bs-target="#products" type="button" role="tab">
                                    {{ __('Products') }}
                                </button>
                            </li>
                        </ul>

                        <div class="tab-content" id="filterTabsContent">
                            <!-- Suppliers Tab -->
                            <div class="tab-pane fade show active" id="suppliers" role="tabpanel">
                                <form>
                                    <div class="mb-2">

                                        <label for="companyType" class="form-label">{{ __('Company Type') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="companyType" name="companyType">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="manufacturer">{{ __('Manufacturer') }}</option>
                                                <option value="wholesaler">{{ __('Wholesaler') }}</option>
                                                <option value="distributor">{{ __('Distributor') }}</option>
                                                <option value="trading">{{ __('Trading Company') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="industry" class="form-label">{{ __('Industry') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="industry" name="industry">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="food">{{ __('Food & Beverage') }}</option>
                                                <option value="chem">{{ __('Chemical') }}</option>
                                                <option value="pharma">{{ __('Pharmaceutical') }}</option>
                                                <option value="cosmetic">{{ __('Cosmetics') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="subIndustry" class="form-label">{{ __('Sub Industry') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="subIndustry" name="subIndustry">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="dairy">{{ __('Dairy Products') }}</option>
                                                <option value="beverage">{{ __('Soft Drinks') }}</option>
                                                <option value="personalcare">{{ __('Personal Care') }}</option>
                                                <option value="skincare">{{ __('Skin Care') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="tradeTerms" class="form-label">{{ __('Trade Terms') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="tradeTerms" name="tradeTerms">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="FOB">FOB</option>
                                                <option value="CIF">CIF</option>
                                                <option value="EXW">EXW</option>
                                                <option value="DDP">DDP</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-check my-2 d-flex align-items-center">
                                        <input class="form-check-input me-2" type="checkbox" id="verifiedSuppliers" name="verifiedSuppliers">
                                        <label class="form-check-label me-auto" for="verifiedSuppliers">{{ __('Verified Suppliers') }}</label>
                                    </div>

                                    <div class="d-flex justify-content-between mt-3">
                                        <button type="submit" class="primary-color">{{ __('Submit') }}</button>
                                        <button type="reset" class="primary-color">{{ __('Reset') }}</button>
                                    </div>
                                </form>
                            </div>

                            <!-- Buyers Tab -->
                            <div class="tab-pane fade" id="buyers" role="tabpanel">
                                <form>
                                    <div class="mb-2">

                                        <label for="companyType" class="form-label">{{ __('Company Type') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="companyType" name="companyType">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="manufacturer">{{ __('Manufacturer') }}</option>
                                                <option value="wholesaler">{{ __('Wholesaler') }}</option>
                                                <option value="distributor">{{ __('Distributor') }}</option>
                                                <option value="trading">{{ __('Trading Company') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="industry" class="form-label">{{ __('Industry') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="industry" name="industry">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="food">{{ __('Food & Beverage') }}</option>
                                                <option value="chem">{{ __('Chemical') }}</option>
                                                <option value="pharma">{{ __('Pharmaceutical') }}</option>
                                                <option value="cosmetic">{{ __('Cosmetics') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="subIndustry" class="form-label">{{ __('Sub Industry') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="subIndustry" name="subIndustry">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="dairy">{{ __('Dairy Products') }}</option>
                                                <option value="beverage">{{ __('Soft Drinks') }}</option>
                                                <option value="personalcare">{{ __('Personal Care') }}</option>
                                                <option value="skincare">{{ __('Skin Care') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="tradeTerms" class="form-label">{{ __('Trade Terms') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="tradeTerms" name="tradeTerms">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="FOB">FOB</option>
                                                <option value="CIF">CIF</option>
                                                <option value="EXW">EXW</option>
                                                <option value="DDP">DDP</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-check my-2 d-flex align-items-center">
                                        <input class="form-check-input me-2" type="checkbox" id="verifiedSuppliers" name="verifiedSuppliers">
                                        <label class="form-check-label me-auto" for="verifiedSuppliers">{{ __('Verified Suppliers') }}</label>
                                    </div>

                                    <div class="d-flex justify-content-between mt-3">
                                        <button type="submit" class="primary-color">{{ __('Submit') }}</button>
                                        <button type="reset" class="primary-color">{{ __('Reset') }}</button>
                                    </div>
                                </form>
                            </div>

                            <!-- Products Tab -->
                            <div class="tab-pane fade" id="products" role="tabpanel">
                                <form>
                                    <div class="mb-2">

                                        <label for="companyType" class="form-label">{{ __('Company Type') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="companyType" name="companyType">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="manufacturer">{{ __('Manufacturer') }}</option>
                                                <option value="wholesaler">{{ __('Wholesaler') }}</option>
                                                <option value="distributor">{{ __('Distributor') }}</option>
                                                <option value="trading">{{ __('Trading Company') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="industry" class="form-label">{{ __('Industry') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="industry" name="industry">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="food">{{ __('Food & Beverage') }}</option>
                                                <option value="chem">{{ __('Chemical') }}</option>
                                                <option value="pharma">{{ __('Pharmaceutical') }}</option>
                                                <option value="cosmetic">{{ __('Cosmetics') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="subIndustry" class="form-label">{{ __('Sub Industry') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="subIndustry" name="subIndustry">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="dairy">{{ __('Dairy Products') }}</option>
                                                <option value="beverage">{{ __('Soft Drinks') }}</option>
                                                <option value="personalcare">{{ __('Personal Care') }}</option>
                                                <option value="skincare">{{ __('Skin Care') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-2">

                                        <label for="tradeTerms" class="form-label">{{ __('Trade Terms') }}</label>
                                        <div class="select-box">
                                            <select class="form-select" id="tradeTerms" name="tradeTerms">
                                                <option selected disabled>{{ __('Select') }}</option>
                                                <option value="FOB">FOB</option>
                                                <option value="CIF">CIF</option>
                                                <option value="EXW">EXW</option>
                                                <option value="DDP">DDP</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-check my-2 d-flex align-items-center">
                                        <input class="form-check-input me-2" type="checkbox" id="verifiedSuppliers" name="verifiedSuppliers">
                                        <label class="form-check-label me-auto" for="verifiedSuppliers">{{ __('Verified Suppliers') }}</label>
                                    </div>

                                    <div class="d-flex justify-content-between mt-3">
                                        <button type="submit" class="primary-color">{{ __('Submit') }}</button>
                                        <button type="reset" class="primary-color">{{ __('Reset') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="container ads mt-2">
            <div class="row h-100">
                @foreach ($banner1 as $banner)
                    <div class="col-sm-6 p-1 h-100">
                        <a href="{{ $banner->status == 'active' && !blank($banner->link) ? $banner->link : '#' }}">
                            @if ($banner->status == 'active')
                                <img src="{{ url($banner->photo->path) }}" class="img-fluid-custom" alt="{{ photo_alt($banner, 'photo', 'banner') }}">
                            @else
                                <img src="{{ url($banner->photo_default->path) }}" class="img-fluid-custom" alt="{{ photo_alt($banner, 'photo_default', 'banner') }}">
                            @endif
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    <!--hero section end-->
    @if (count($suppliers))
        <!--service section start-->
        <section class="blog-section pt-20 overflow-hidden pb-0">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{ read_lang_word('top-suppliers1') }}</span>
                            <h2 class="mt-2 h1">{{ read_lang_word('top-suppliers2') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-card-wrapper mt-2">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="top_suppliers h4-categories-slider swiper overflow-visible">
                            <div class="swiper-wrapper">
                                @foreach ($suppliers as $item)
                                    <div class="swiper-slide text-center px-1">
                                        <a href="{{ route('front.supplier.show', $item->u_id) }}" class="top_suppliers_a">
                                            <img src="{{ $item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/favicon.png') }}" class="img-fluid  bg-white p-1"
                                                alt="{{ photo_alt($item, 'photo', $item->name) }}">
                                            <h3 class="suppliers_name fs-13">{{ $item->name }}</h3>
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                            <div class="flash-controls sflash-button-prev flash-button-prev"><i class="fa-solid fa-angle-left"></i></div>
                            <div class="flash-controls sflash-button-next flash-button-next"><i class="fa-solid fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--service section end-->
    @endif
    @if (count($banner2))
        <section class="bg-white pt-60 pb-60 bg-primary-light position-relative z-1 overflow-hidden">
            <div class="container">
                <div class="row">
                    @foreach ($banner2 as $banner)
                        <div class="col-sm-6 mx-auto">
                            <a href="{{ !blank($banner->link) ? $banner->link : '#' }}">
                                <img src="{{ url($banner->photo->path) }}" class="img-fluid-custom" alt="{{ photo_alt($banner, 'photo', 'banner') }}">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    @if (count($products))
        <!--service section start-->
        <section class="blog-section pt-20 overflow-hidden pb-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{ read_lang_word('product') }}</span>
                            <h2 class="mt-2 h1">{{ read_lang_word('products-new') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-card-wrapper mt-2">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="product_swiper swiper mySwiper">
                            <div class="swiper-wrapper">
                                @foreach ($products as $product)
                                    <div class="swiper-slide px-1 py-2">
                                        @include('front.product.includes.card', ['item' => $product])
                                    </div>
                                @endforeach
                            </div>
                            <div class="swiper-pagination swiper-pagination1"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--service section end-->
    @endif
    @if (count($gallery))
        <!--add center start-->
        <section class="add-center pt-60" data-background="{{ url('assets/front/img/shapes/banner-bg.jpg') }}">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-5 col-lg-6">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative lead text-primary shape-primary">{{ read_lang_word('gallery') }}</span>
                            <h2 class="h1 text-white mt-2 mb-30">{{ read_lang_word('gallery-last') }}</h2>
                            <a href="{{ route('front.gallery') }}" class="btn btn-primary">{{ read_lang_word('all') }}</a>
                        </div>
                    </div>
                </div>
                <div class="banner-slider swiper pb-80 mt-5">
                    <div class="swiper-wrapper">
                        @foreach ($gallery as $gall)
                            <div class="single-banner swiper-slide gallery_card_index">
                                @include('front.gallery.includes.card', ['gall' => $gall])
                            </div>
                        @endforeach
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </section>
        <!--add center end-->
    @endif
    @if (count($product_service))
        <!--service section start-->
        <section class="bg-white pt-60 pb-60 bg-primary-light position-relative z-1 overflow-hidden">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{ read_lang_word('service') }}</span>
                            <h2 class="mt-2 h1">{{ read_lang_word('our-service') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-card-wrapper mt-2">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="product_service_swiper h4-categories-slider swiper overflow-visible">
                            <div class="swiper-wrapper">
                                @foreach ($product_service as $service)
                                    <div class="swiper-slide py-2 px-1">
                                        @include('front.product.includes.card', ['item' => $service])
                                    </div>
                                @endforeach
                            </div>
                            <div class="swiper-pagination swiper-pagination2"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--service section end-->
    @endif
    @if (count($blogs))
        <!--blog section start-->
        <section class="blog-section pt-20 overflow-hidden pb-0">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{ read_lang_word('blog') }}</span>
                            <h2 class="mt-2 h1">{{ read_lang_word('last-blog') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-card-wrapper mt-2">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="h4_ct_slider_2 h4-categories-slider swiper overflow-visible">
                            <div class="swiper-wrapper">
                                @foreach ($blogs as $blog)
                                    <div class="swiper-slide px-1">
                                        @include('front.blog.includes.card', ['item' => $blog])
                                    </div>
                                @endforeach
                            </div>
                            <div class="flash-controls flash-button-prev"><i class="fa-solid fa-angle-left"></i></div>
                            <div class="flash-controls flash-button-next"><i class="fa-solid fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--blog section end-->
    @endif
    @if (count($partners))
        <!--service section start-->
        <section class="bg-white pt-60 pb-60 bg-primary-light position-relative z-1 overflow-hidden">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{ read_lang_word('partner1') }}</span>
                            <h2 class="mt-2 h1">{{ read_lang_word('partner2') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-card-wrapper mt-2">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="top_suppliers h4-categories-slider swiper overflow-visible">
                            <div class="swiper-wrapper">
                                @foreach ($partners as $item)
                                    <div class="swiper-slide text-center px-1">
                                        <a href="{{ $item->link ?? '#' }}" class="top_suppliers_a">
                                            <img src="{{ $item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/home1/blog-1.jpg') }}" class="img-fluid  p-1  bg-white"
                                                alt="{{ photo_alt($item, 'photo', read_lang($item, 'title')) }}">
                                            <h3 class="suppliers_name fs-13">{{ read_lang($item, 'title') }}</h3>
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                            <div class="flash-controls sflash-button-prev flash-button-prev"><i class="fa-solid fa-angle-left"></i></div>
                            <div class="flash-controls sflash-button-next flash-button-next"><i class="fa-solid fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--service section end-->
    @endif
@endsection
@section('scripts')
    <script src="{{ url('assets/front/js/fancybox.js') }}"></script>
    @include('front.includes.req')
@endsection
