@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
        <section class="blog-section pt-70 overflow-hidden pb-70">
            <div class="container">
                <div class="blog-card-wrapper">
                    <div class="row g-4 justify-content-center">
                        <div class="col-12 ">
                            <div class="container-fluid">
                                <div class="row">
                                    @if(count($products))
                                        @foreach($products as $item)
                                            <div class="col-lg-3 col-sm-4 col-6 px-1 pb-4">
                                                @include('front.product.includes.card',['item'=>$item])
                                            </div>
                                        @endforeach
                                            <div class="col-12 mt-5 paginate-div text-center">
                                                {{$products->appends(Request::except('page'))->links("cpag.custom")}}
                                            </div>
                                    @else
                                        <div class="col-12 alert alert-danger text-center">
                                            {{read_lang_word('not-found')}}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
@endsection
@section('scripts') @endsection
