@extends('front.layouts.front')
@section('styles')
    <style>
        .w-100.btn-secondary::before
        {
            border-radius: 50px;
        }
    </style>
@endsection
@section('body')
    @if(count($suppliers))
    @foreach($suppliers as $key=>$supplier)
        <section class="blog-section pt-20 overflow-hidden pb-20">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{$supplier->name}}</span>
                            <h2 class="mt-2 h1">{{read_lang_word('product-found')}}</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="product_swiper2 swiper mySwiper">
                            <div class="swiper-wrapper">
                                @foreach($suppliers->products_active as $item)
                                    <div class="swiper-slide px-1 py-2">
                                        @include('front.product.includes.card',['item'=>$item])
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center mt-4">
                    <div class="col-xl-12">
                        <a href="{{route('front.supplier.show',$supplier->u_id)}}" target="_blank" class="btn btn-secondary font-weight-bold w-100">
                            {{read_lang_word('profile-supplier')}} {{$supplier->name}}
                        </a>
                    </div>
                </div>
            </div>
        </section>
    @endforeach
    @else
        <div class="col-12 alert alert-danger text-center">
            {{read_lang_word('not-found')}}
        </div>
    @endif
@endsection
@section('scripts') @endsection
