@if(count($certificates))
    <h2 class="mt-5">{{read_lang_word('supplier-certificates')}}</h2>
    <div class="mb-3">
        <div id="carouselExample" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                @foreach($certificates as $key=>$certificate)
                    <div class="carousel-item {{$key==0 ? 'active' : ''}}">
                        <img src="{{url($certificate->photo->path)}}" loading="lazy" href="{{url($certificate->photo->path)}}" data-fancybox="certificates-img" class="d-block certificates-img w-100" alt="{{photo_alt($certificate,'photo',$certificate->type_title)}}">
                        <p class="text-center">{{$certificate->get_type_title()}}</p>
                    </div>
                @endforeach
            </div>
            @if(count($certificates) > 1)
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample"
                    data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExample"
                    data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
            @endif
        </div>
    </div>
@endif