@if(count($gallery))
    <h2 class="mt-5">{{read_lang_word('supplier-gallery')}}</h2>
    <div class="mb-3">
        <div id="carouselgallery" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                @foreach($gallery as $key=>$photo)
                    <div class="carousel-item {{$key==0 ? 'active' : ''}}">
                        <img src="{{url($photo->photo->path)}}" loading="lazy" href="{{url($photo->photo->path)}}"
                             data-fancybox="galley-img" data-caption="<p class='text-center'>{{$photo->title}}</p>"
                             class="d-block certificates-img w-100"
                             alt="{{photo_alt($photo,'photo',$photo->type_title)}}">
                        @if(count($photo->gallery_p))
                            @foreach($photo->gallery_p as $gall)
                                <img src="{{url($gall->file)}}" loading="lazy" href="{{url($gall->file)}}"
                                     data-fancybox="galley-img"
                                     data-caption="<p class='text-center'>{{$photo->title}}</p>" class="d-none">
                            @endforeach
                        @endif
                        <p class="text-center">{{$photo->title}}</p>
                    </div>
                @endforeach
            </div>
            @if(count($gallery) > 1)
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselgallery"
                    data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselgallery"
                    data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
            @endif
        </div>
    </div>
@endif

@if(count($gallery_v))
    <h2 class="mt-5">{{read_lang_word('supplier-gallery-v')}}</h2>
    <div class="mb-3">
        <div id="carouselgallery_v" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                @foreach($gallery_v as $key=>$photo_v)
                    <div class="carousel-item {{$key==0 ? 'active' : ''}}">
                        {{--                        <img src="{{url($photo_v->photo->path)}}" loading="lazy" href="{{url($photo_v->photo->path)}}" data-fancybox="galley-video" data-caption="<p class='text-center'>{{$photo_v->title}}</p>" class="d-block certificates-img w-100" alt="{{photo_alt($photo_v,'photo',$photo_v->type_title)}}">--}}
                        @if(count($photo_v->gallery_v))
                            @foreach($photo_v->gallery_v as $key=>$gall)
                                <img src="{{$key == 0 ? url('assets/front/video_default.png') : url($gall->file)}}"
                                     loading="lazy" href="{{url($gall->file)}}" class="d-block certificates-img w-100"
                                     data-fancybox="galley-video"
                                     data-caption="<p class='text-center'>{{$photo_v->title}}</p>"
                                     class="{{$key > 0 ? 'd-none' : ''}}">
                            @endforeach
                        @endif
                        <p class="text-center">{{$photo_v->title}}</p>
                    </div>
                @endforeach
            </div>
            @if(count($gallery_v) > 1)
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselgallery_v"
                        data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselgallery_v"
                        data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            @endif
        </div>
    </div>
@endif