@extends('front.layouts.front')
@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}">
    <style>
        @if($user->header_profile && is_file($user->header_profile->path))
        .header-image {
            background-image: url('{{url($user->header_profile->path)}}'); /* تصویر خدمات طراحی سایت */
        }

        @elseif($sett->header && is_file($sett->header->path))
        .header-image {
            background-image: url('{{url($sett->header->path)}}'); /* تصویر خدمات طراحی سایت */
        }

        @endif


        td,th{
            vertical-align: middle;
        }
    </style>
@endsection
@section('body')
    <!-- تصویر هدر -->
    <div class="header-image"></div>

    <!-- بخش‌های صفحه -->
    <div class="container my-4">

        <div class="row supplier_profile">
            <!-- ستون کوچک برای اطلاعات پروفایل -->
            <div class="col-lg-4 col-md-12">
                <div class="sidebar">
                    @include('front.supplier.includes.profile')
                    @if(count($addresses) && $days > 0 && $user->verify_type == 'vip')
                        @include('front.supplier.includes.contact')
                    @endif
                    @include('front.supplier.includes.cats')
                    @include('front.supplier.includes.abouts')
                    @include('front.supplier.includes.certificates')
                    @include('front.supplier.includes.gallery')
                </div>
            </div>
            <!-- ستون بزرگ برای محصولات -->
            <div class="col-lg-8 col-md-12">
                <div class="container-fluid">
                    <div class="row">
                        @foreach($products as $product)
                            <div class="col-xxl-3 col-lg-4 col-md-6 col-sm-4 col-6 px-1 pb-4">
                                @include('front.product.includes.card',['item'=>$product])
                            </div>
                        @endforeach
                        <div class="col-12 mt-3 text-center">
                            {{$products->appends(Request::except('page'))->links('cpag.custom')}}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('scripts')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
    <script>
        document.querySelectorAll('.toggle-submenu').forEach(toggle => {
            toggle.addEventListener('click', function (e) {
                e.stopPropagation(); // جلوگیری از انتشار رویداد به عناصر والد
                const submenu = this.parentElement.querySelector('.submenu');
                submenu.classList.toggle('active'); // اضافه یا حذف کلاس active

                // تغییر علامت + به - و بالعکس
                if (this.textContent === '+') {
                    this.textContent = '-';
                } else {
                    this.textContent = '+';
                }
            });
        });

        // جلوگیری از باز شدن زیرمنو هنگام کلیک روی لینک
        document.querySelectorAll('.has-submenu > a').forEach(link => {
            link.addEventListener('click', function (e) {
                e.stopPropagation(); // جلوگیری از باز شدن زیرمنو
            });
        });
    </script>
@endsection


