@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
    @if(count($blogs))
        <!--blog section start-->
        <section class="blog-section pt-120 overflow-hidden pb-120">
            <div class="container">
                <div class="blog-card-wrapper mt-5">
                    <div class="row g-4 justify-content-center">
                        @foreach($blogs as $item)
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10 px-1">
                                @include('front.blog.includes.card',['item'=>$item])
                            </div>
                        @endforeach
                        <div class="col-12 mt-5 paginate-div text-center">
                            {{$blogs->appends(Request::except('page'))->links("pagination::bootstrap-4")}}
                        </div>
                    </div>
                    <div class="row g-4 justify-content-center mt-3">
                        <div class="col-12">
                            {!! read_lang($item, 'text') !!}
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--blog section end-->
    @endif
@endsection
@section('scripts') @endsection
