<div x-data="{ activeTab: 'basic' }" wire:ignore>
    @if($label)
        <label class="form-label">{{ $label }}{!! $required ? " <span class='text-danger'>*</span>" : '' !!}</label>
    @endif
        <div class="btn-group btn-group-sm mb-2 d-table" role="group">
            <button type="button"
                    @click="activeTab = 'basic'"
                    :class="{'btn-primary text-white': activeTab == 'basic', 'btn-outline-primary': activeTab != 'basic'}"
                    class="btn">
                {{ translateText('Base', lang_admin()) }}
            </button>
            <button type="button"
                    @click="activeTab = 'advanced'"
                    :class="{'btn-primary text-white': activeTab == 'advanced', 'btn-outline-primary': activeTab != 'advanced'}"
                    class="btn">
                {{ translateText('Advanced', lang_admin()) }}
            </button>
        </div>
    <textarea
            x-data
            x-init="
            let editor;
            function initEditor() {
                if (window.ckeditorInstances && window.ckeditorInstances['{{ $uniqueKey }}']) {
                    window.ckeditorInstances['{{ $uniqueKey }}'].destroy(true);
                }

                let config = {
                    filebrowserImageBrowseUrl: @js($filebrowserImageBrowseUrl),
                    filebrowserImageUploadUrl: @js($filebrowserImageUploadUrl),
                    filebrowserBrowseUrl: @js($filebrowserBrowseUrl),
                    filebrowserUploadUrl: @js($filebrowserUploadUrl),
                    language: @js($language),
                    contentsLangDirection: @js($contentsLangDirection),
                    autoUpdateElement: false,
                    height: @js($height),
                };

                if (activeTab === 'basic') {
                    config.toolbar = @js($toolbar);
                }

                editor = CKEDITOR.replace($el, config);
                editor.setData(@js($value));

                editor.on('change', function() {
                    window.ckeditorValues = window.ckeditorValues || {};
                    window.ckeditorValues['{{ $uniqueKey }}'] = editor.getData();
                });

                window.ckeditorInstances = window.ckeditorInstances || {};
                window.ckeditorInstances['{{ $uniqueKey }}'] = editor;

                window.addEventListener('update-ckeditor-values', () => {
                    if (window.ckeditorValues && window.ckeditorValues['{{ $uniqueKey }}'] !== undefined) {
                        @this.dispatch('ckeditor-updated', { field: '{{ $field }}', value: window.ckeditorValues['{{ $uniqueKey }}'] });
                        console.log('yes');
                    }
                });
            }

            $nextTick(() => {
                initEditor();
            });

            $watch('activeTab', () => {
                initEditor();
            });
        "
            wire:model.defer="{{ $field }}"
            id="{{ $uniqueKey }}"
        {{ $required ? 'required' : '' }}
            {{ $disabled ? 'disabled' : '' }}
    >{{ $value }}</textarea>
</div>

@push('styles')
    <style>
        .cke_chrome {
            border: 1px solid #d1d1d1 !important;
            border-radius: 4px !important;
        }
        .tabs button {
            margin-right: 5px;
        }
    </style>
@endpush