<div x-data="{ value: @entangle($model), validate: () => $wire.dispatch('validate-input', { field: '{{ $model }}', value }) }"
     x-on:blur="validate"
     x-on:input.debounce.500ms="validate">
    @if($label)
        <label class="form-label">{{ $label }} {{ $required ? '*' : '' }}</label>
    @endif
    <input
            type="{{ $type }}"
            wire:model="{{ $model }}"
            class="form-control {{ !empty($errors) ? 'is-invalid' : '' }}"
    {{ $required ? 'required' : '' }}
    @foreach($attributes1 as $key => $value)
        {{ $key }}="{{ $value }}"
    @endforeach
    >
    @if(!empty($errors))
        <div class="invalid-feedback">
            @foreach($errors as $error)
                {{ $error }}<br>
            @endforeach
        </div>
    @endif
</div>
@push('styles')
    <style>
        .form-label { font-weight: 500; color: #333; }
        .form-control { border-radius: 8px; }
        .is-invalid { border-color: #dc3545; }
        .invalid-feedback { color: #dc3545; font-size: 0.875rem; }
    </style>
@endpush
