<div>
    <livewire:dashboard.page-title :page_title="$page_title" />

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12 col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-header border-0">
                        <h5 class="card-title">{{ $title }}</h5>
                    </div>

                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <livewire:components.tom-select
                                            :options="$bussiness_types"
                                            :value="$data['bussiness_type']"
                                            field="bussiness_type"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Business type', lang_admin())"
                                            placeholder="{{ translateText('Select Business type', lang_admin()) }}"
                                            uniqueKey="bussiness_type"
                                    />
                                </div>

                                <div class="col-md-12 mb-3">
                                    <livewire:components.tom-select
                                            :options="$categories"
                                            :value="$data['category_id']"
                                            field="category_id"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Business Category', lang_admin())"
                                            placeholder="{{ translateText('Select Business Category', lang_admin()) }}"
                                            uniqueKey="category_id"
                                    />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label class="form-label">{{ translateText('Registration Number', lang_admin()) }}</label>
                                        <input type="text" wire:model="data.registration_number" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$ownership_models"
                                            :value="$data['ownership_model']"
                                            field="ownership_model"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :label="translateText('Ownership Model', lang_admin())"
                                            placeholder="{{ translateText('Select Ownership Model', lang_admin()) }}"
                                            uniqueKey="ownership_model"
                                    />
                                </div>

                                <div class="col-md-12 mb-3" x-data="keywordManager()">
                                    <label class="form-label">{{ translateText('Main Product keywords', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <div id="product-keywords-container">
                                        <template x-for="(keyword, index) in keywords" :key="index">
                                            <div class="d-flex mb-2">
                                                <input type="text" x-model="keywords[index]" class="form-control me-2" placeholder="{{ translateText('Product keyword', lang_admin()) }}">
                                                <button type="button" @click="removeKeyword(index)" class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                            </div>
                                        </template>
                                    </div>
                                    <button type="button" @click="addKeyword" class="btn btn-success mt-2"><i class="fas fa-plus"></i></button>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label class="form-label">{{ translateText('Tax Identification Number', lang_admin()) }}</label>
                                        <input type="text" wire:model="data.tax_identification_number" class="form-control">
                                        <small class="text-muted">{{ translateText("Your Tax Identification Number will only be used for identity verification and won't be shared with suppliers.", lang_admin()) }}</small>
                                        @error('data.tax_identification_number') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                {{ translateText('Submit', lang_admin()) }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('styles')

    @endpush

    @push('scripts')
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.store('formState', {
                    keywords: @js($data['main_product_keywords'] ?? []),
                    updateKeywords(value) { this.keywords = value; }
                });

                Alpine.data('keywordManager', () => ({
                    keywords: Alpine.store('formState').keywords,
                    addKeyword() {
                        this.keywords.push('');
                        Alpine.store('formState').updateKeywords(this.keywords);
                    },
                    removeKeyword(index) {
                        this.keywords.splice(index, 1);
                        Alpine.store('formState').updateKeywords(this.keywords);
                    },
                    init() {
                        this.$watch('keywords', (value) => {
                            Alpine.store('formState').updateKeywords(value);
                        });

                        this.$el.closest('form').addEventListener('submit', () => {
                        @this.set('data.main_product_keywords', this.keywords);
                        });
                    }
                }));
            });
        </script>
    @endpush
</div>