<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h5>{{ $title }}</h5>
                        <a class="btn btn-danger" href="{{route('company-faq.manage',$item->dashboard_code)}}">Back</a>
                    </div>
                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <div class="row mt-3">
                                <nav class="nav nav-tabs">
                                    @foreach(tab_langs() as $lang)
                                        <button class="nav-link {{ $lang->status == 'default' ? 'active' : '' }}"
                                                type="button"
                                                data-bs-toggle="tab"
                                                data-bs-target="#lang-{{ $lang->lang }}">
                                            {{ strtoupper($lang->lang) }}
                                        </button>
                                    @endforeach
                                </nav>

                                <div class="tab-content p-3 border border-top-0">
                                    @foreach(tab_langs() as $lang)
                                        @php
                                            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                            $dir = $lang->align;
                                        @endphp
                                        <div class="tab-pane fade {{ $lang->status == 'default' ? 'show active' : '' }}"
                                             id="lang-{{ $lang->lang }}" style="direction: {{ $dir }}">
                                            <div wire:ignore class="col-md-12 mb-3" style="direction:ltr">
                                                <label>{{ translateText('Status', lang_admin()) }}</label>
                                                <div class="form-check form-switch form-check-reverse"
                                                     style="padding-left: 20px">
                                                    <input wire:model="data.status{{ $suffix }}"
                                                           class="form-check-input badge-light-info ms-2"
                                                           id="flexSwitchCheckReverse{{ $suffix }}" type="checkbox" {{$data['status'.$suffix] == 'active' ? 'checked' : ''}}>
                                                    <label class="form-check-label"
                                                           for="flexSwitchCheckReverse{{ $suffix }}">
                                                        {{ translateText('Will it be published?', lang_admin()) }}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label>
                                                    {{ translateText('Question', lang_admin()) }}
                                                    {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                                </label>
                                                <textarea {{ $lang->status == 'default' ? "required" : ''}}  type="text"
                                                          wire:model="data.question{{ $suffix }}"
                                                          class="form-control"></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label>
                                                    {{ translateText('Answer', lang_admin()) }}
                                                    {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                                </label>
                                                <textarea {{ $lang->status == 'default' ? "required" : ''}}  type="text"
                                                          wire:model="data.answer{{ $suffix }}"
                                                          class="form-control"></textarea>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <button wire:loading.attr="disabled" type="submit" class="btn btn-primary mt-3">
                                {{ translateText('Submit', lang_admin()) }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>