<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>

    <div class="container-fluid datatable-init">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0 card-no-border d-flex justify-content-between">
                        <h5>{{$title}}</h5>
                        <livewire:dashboard.company.company-faq.create :dashboardCode="$dashboardCode"/>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive custom-scrollbar">
                            <table class="display table-striped border" id="basic-1">
                                <thead>
                                <tr>
                                    <th>Question</th>
                                    <th>Answer</th>
                                    <th>Last modified</th>
                                    <th>Status</th>
                                    <th>Sort</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($items as $item)
                                    <tr>
                                        <td>{{ $item->question }}</td>
                                        <td>{{ $item->answer }}</td>
                                        <td>{{ $item->updated_at }}</td>
                                        <td>
                                            <span class="badge badge-light-{{ $item->status == 'active' ? 'success' : 'warning'}}">{{$item->status}}</span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center sort-div">
                                                <input type="number" class="form-control me-1 p-1 text-center sort-input" wire:model="sort.{{ $item->id }}" id="sort-{{ $item->id }}">
                                                <button type="button" class="btn btn-primary btn-sm p-1 sort-button"
                                                        onclick="updateSort({{ $item->id }}, document.getElementById('sort-{{ $item->id }}').value)">
                                                    <i class="fa fa-save"></i>
                                                </button>
                                            </div>
                                        </td>
                                        <td>
                                            <ul class="action">
                                                <li class="edit">
                                                    <a href="{{route('company-faq.edit',$item->id)}}"><i class="fa-regular fa-pen-to-square"></i></a>
                                                </li>
                                                <li class="delete">
                                                    <a onclick="deleteItem({{ $item->id }})" style="cursor:pointer;">
                                                        <i class="fa-solid fa-trash-can"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>

@push('styles')

@endpush
@push('scripts')

@endpush