<div>
    <livewire:dashboard.page-title :page_title="$page_title" />

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h5>{{ $title }}</h5>
                        <a class="btn btn-danger" href="{{route('company-office.manage',$item->dashboard_code)}}">Back</a>
                    </div>
                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <div class="row mt-3">
                                <div class="col-md-3 mb-3">
                                    <livewire:components.tom-select
                                            :options="$countries"
                                            :value="$data['country_id']"
                                            field="country_id"
                                            :isMultiple="false"
                                            :immediateUpdate="true"
                                            :required="true"
                                            :label="translateText('Country', lang_admin())"
                                            placeholder="{{ translateText('Select Country', lang_admin()) }}"
                                            uniqueKey="country_id" />
                                </div>

                                <div class="col-md-3 mb-3">
                                    <livewire:components.tom-select
                                            :options="$states"
                                            :value="$data['state_id']"
                                            field="state_id"
                                            :isMultiple="false"
                                            :immediateUpdate="true"
                                            :required="true"
                                            :label="translateText('State', lang_admin())"
                                            placeholder="{{ translateText('Select State', lang_admin()) }}"
                                            :disabled="!count($states)"
                                            uniqueKey="state_id" />
                                </div>

                                <div class="col-md-3 mb-3">
                                    <livewire:components.tom-select
                                            :options="$cities"
                                            :value="$data['city_id']"
                                            field="city_id"
                                            :isMultiple="false"
                                            :immediateUpdate="true"
                                            :required="true"
                                            :label="translateText('City', lang_admin())"
                                            placeholder="{{ translateText('Select City', lang_admin()) }}"
                                            :disabled="!count($cities)"
                                            uniqueKey="city_id" />
                                </div>

                                <div class="col-md-3 mb-3">
                                    <livewire:components.tom-select
                                            :options="$time_zone"
                                            :value="$data['time_zone']"
                                            field="time_zone"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Time Zone', lang_admin())"
                                            placeholder="{{ translateText('Select Time Zone', lang_admin()) }}"
                                            uniqueKey="time_zone" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Street', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <input class="form-control" wire:model="data.street" type="text">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Post Code', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <input class="form-control" wire:model="data.post_code" type="text">
                                </div>

                            </div>
                            <button wire:loading.attr="disabled" type="submit" class="btn btn-primary mt-3">
                                {{ translateText('Submit', lang_admin()) }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('styles')
    @endpush

    @push('scripts')
    @endpush
</div>