<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>
    <div class="container-fluid datatable-init">
        <div class="row">
            <div class=" col-sm-12">
                <div class="card">
                    <div class="card-header pb-0 card-no-border d-flex justify-content-between">
                        <h5>{{$title}}</h5>
                        <livewire:dashboard.company.company-office.create :dashboardCode="$dashboardCode"/>
                    </div>
                </div>
            </div>
            @foreach($items as $item)
            <div class=" col-sm-4">
                <div class="card">
                    <div class="card-header pb-0 card-no-border d-flex justify-content-between">
                        <h5>{{$item->type}}</h5>
                    </div>
                    <div class="card-body row">
                        <div class="col-12 mb-2">
                            <label>{{ translateText('Country', lang_admin()) }}</label>
                            <input class="form-control disabled" disabled value="{{$item->country->name ?? '---'}}">
                        </div>
                        <div class="col-12 mb-2">
                            <label>{{ translateText('State', lang_admin()) }}</label>
                            <input class="form-control disabled" disabled value="{{$item->state->name ?? '---'}}">
                        </div>
                        <div class="col-12 mb-2">
                            <label>{{ translateText('City', lang_admin()) }}</label>
                            <input class="form-control disabled" disabled value="{{$item->city->name ?? '---'}}">
                        </div>
                        <div class="col-6 mb-2">
                            <label>{{ translateText('Street ', lang_admin()) }}</label>
                            <input class="form-control disabled" disabled value="{{$item->street ?? '---'}}">
                        </div>
                        <div class="col-6 mb-2">
                            <label>{{ translateText('Post Code ', lang_admin()) }}</label>
                            <input class="form-control disabled" disabled value="{{$item->post_code ?? '---'}}">
                        </div>
                        <div class="col-12 mb-2">
                            <label>{{ translateText('Time Zone ', lang_admin()) }}</label>
                            <input class="form-control disabled" disabled value="{{$item->time_zone ?? '---'}}">
                        </div>
                        <div class="card-footer">
                            <ul class="action d-flex justify-content-between">
                                <li class="edit"><a href="{{route('company-office.edit',$item->id)}}"><i
                                                style="font-size: 24px" class="fa-regular fa-pen-to-square"></i></a></li>
                                @if($item->type != 'head')
                                    <li class="delete">
                                        <a onclick="deleteItem({{ $item->id }})"
                                           style="cursor:pointer;">
                                            <i style="font-size: 24px" class="fa-solid fa-trash-can"></i>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

    </div>
</div>
