<div>
    <livewire:dashboard.page-title :page_title="$page_title" />

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5>{{ $title }}</h5>
                    </div>
                    <div class="card-body">
                        <form enctype="multipart/form-data" x-data="{ isUploading: false }" wire:submit.prevent="save"
                              x-init="
                                $el.addEventListener('submit', () => {
                                    if (window.__ckeditorHandlers) {
                                        window.__ckeditorHandlers.forEach(handler => handler());
                                    }
                                });
                              ">
                            <nav class="nav nav-tabs">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{ $lang->status == 'default' ? 'active' : '' }}"
                                            type="button"
                                            data-bs-toggle="tab"
                                            data-bs-target="#lang-{{ $lang->lang }}">
                                        {{ strtoupper($lang->lang) }}
                                    </button>
                                @endforeach
                            </nav>

                            <div class="tab-content p-3 border border-top-0">
                                @foreach(tab_langs() as $lang)
                                    @php
                                        $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                        $dir = $lang->align;
                                    @endphp

                                    <div class="tab-pane fade {{ $lang->status == 'default' ? 'show active' : '' }}"
                                         id="lang-{{ $lang->lang }}" style="direction: {{ $dir }}">

                                        <div class="mb-3">
                                            <label>
                                                {{ translateText('Contact Person', lang_admin()) }}
                                                {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                            </label>
                                            <input type="text"
                                                   wire:model="data.contact_person{{ $suffix }}"
                                                   class="form-control">
                                        </div>

                                        <div class="mb-3">
                                            <label>
                                                {{ translateText('Job Title', lang_admin()) }}
                                                {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                            </label>
                                            <input type="text"
                                                   wire:model="data.job_title{{ $suffix }}"
                                                   class="form-control">
                                        </div>

                                        <div class="mb-3">
                                            <label>
                                                {{ translateText('Department', lang_admin()) }}
                                            </label>
                                            <input type="text"
                                                   wire:model="data.department{{ $suffix }}"
                                                   class="form-control">
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <div class="row mt-3"
                                 x-on:livewire-upload-start="isUploading = true"
                                 x-on:livewire-upload-finish="isUploading = false"
                                 x-on:livewire-upload-error="isUploading = false">
                                <div class="col-md-6">
                                    <label>{{ translateText('Email Address', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <input class="form-control" wire:model="data.email_address" type="email">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Backup Email', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <input class="form-control" wire:model="data.backup_email" type="email">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Phone Number', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <div class="d-flex">
                                        <div class="me-2" style="width: 20%;">
                                            <livewire:components.tom-select
                                                    :options="$country_code"
                                                    :value="$data['country_code1']"
                                                    field="country_code1"
                                                    :isMultiple="false"
                                                    :immediateUpdate="false"
                                                    :label="''"
                                                    placeholder="{{ translateText('Select Country Code', lang_admin()) }}"
                                                    uniqueKey="country_code1" />
                                        </div>
                                        <input class="form-control me-2" wire:model="data.city_code" type="text" placeholder="{{ translateText('City Code', lang_admin()) }}" style="width: 20%;">
                                        <input class="form-control" wire:model="data.phone_number" type="text" placeholder="{{ translateText('Number', lang_admin()) }}" style="width: 60%;">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Mobile Number', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <div class="d-flex">
                                        <div class="me-2" style="width: 30%;">
                                            <livewire:components.tom-select
                                                    :options="$country_code"
                                                    :value="$data['country_code2']"
                                                    field="country_code2"
                                                    :isMultiple="false"
                                                    :immediateUpdate="false"
                                                    :label="''"
                                                    placeholder="{{ translateText('Select Country Code', lang_admin()) }}"
                                                    uniqueKey="country_code2" />
                                        </div>
                                        <input class="form-control" wire:model="data.mobile_number" type="text" placeholder="{{ translateText('Number', lang_admin()) }}" style="width: 70%;">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Fax Number', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <div class="d-flex">
                                        <div class="me-2" style="width: 20%;">
                                            <livewire:components.tom-select
                                                    :options="$country_code"
                                                    :value="$data['country_code3']"
                                                    field="country_code3"
                                                    :isMultiple="false"
                                                    :immediateUpdate="false"
                                                    :label="''"
                                                    placeholder="{{ translateText('Select Country Code', lang_admin()) }}"
                                                    uniqueKey="country_code3" />
                                        </div>
                                        <input class="form-control me-2" wire:model="data.city_code2" type="text" placeholder="{{ translateText('City Code', lang_admin()) }}" style="width: 20%;">
                                        <input class="form-control" wire:model="data.fax_number" type="text" placeholder="{{ translateText('Number', lang_admin()) }}" style="width: 60%;">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$langS"
                                            :value="$data['supported_languages']"
                                            field="supported_languages"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Supported Languages', lang_admin())"
                                            placeholder="{{ translateText('Select Languages', lang_admin()) }}"
                                            uniqueKey="supported_languages" />
                                </div>

                                <div class="col-md-12 mb-3" x-data="socialMediaManager()">
                                    <label>{{ translateText('Social Media', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <div id="social-media-container">
                                        <template x-for="(media, index) in socialMedia" :key="index">
                                            <div class="d-flex mb-2 input-group">
                                                <select x-model="media.type" class="form-control">
                                                    <option value="" disabled>{{ translateText('Select Social Media', lang_admin()) }}</option>
                                                    @foreach($social_media_types as $key => $value)
                                                        <option value="{{ $key }}">{{ $value }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="text" x-model="media.value" class="form-control" placeholder="{{ translateText('Number / ID', lang_admin()) }}">
                                                <button type="button" @click="removeSocialMedia(index)" class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                            </div>
                                        </template>
                                    </div>
                                    <button type="button" @click="addSocialMedia" class="btn btn-success mt-2"><i class="fas fa-plus"></i></button>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.tom-select
                                            :options="$countries"
                                            :value="$data['country_id']"
                                            field="country_id"
                                            :isMultiple="false"
                                            :immediateUpdate="true"
                                            :required="true"
                                            :label="translateText('Country', lang_admin())"
                                            placeholder="{{ translateText('Select Country', lang_admin()) }}"
                                            uniqueKey="country_id" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.tom-select
                                            :options="$states"
                                            :value="$data['state_id']"
                                            field="state_id"
                                            :isMultiple="false"
                                            :immediateUpdate="true"
                                            :required="true"
                                            :label="translateText('State', lang_admin())"
                                            placeholder="{{ translateText('Select State', lang_admin()) }}"
                                            :disabled="!count($states)"
                                            uniqueKey="state_id" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.tom-select
                                            :options="$cities"
                                            :value="$data['city_id']"
                                            field="city_id"
                                            :isMultiple="false"
                                            :immediateUpdate="true"
                                            :required="true"
                                            :label="translateText('City', lang_admin())"
                                            placeholder="{{ translateText('Select City', lang_admin()) }}"
                                            :disabled="!count($cities)"
                                            uniqueKey="city_id" />
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>{{ translateText('Street', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <input class="form-control" wire:model="data.street" type="text">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Post Code', lang_admin()) }} <span class="text-danger">*</span></label>
                                    <input class="form-control" wire:model="data.post_code" type="text">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$time_zone"
                                            :value="$data['time_zone']"
                                            field="time_zone"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Time Zone', lang_admin())"
                                            placeholder="{{ translateText('Select Time Zone', lang_admin()) }}"
                                            uniqueKey="time_zone" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <livewire:components.file-upload
                                            type="profile"
                                            :isMultiple="false"
                                            :label="translateText('Profile', lang_admin())"
                                            acceptedFormats="jpeg,jpg,png,webp"
                                            maxSize="2048"
                                            dimensions="500x500"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\ContactInformation"
                                            :data="$data['profile']"
                                            uniqueKey="file-upload-profile"
                                            wire:key="file-upload-profile"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company" />
                                </div>
                            </div>
                            <button style="display: none" x-show="!isUploading" wire:loading.attr="disabled" type="submit" class="btn btn-primary mt-3">
                                {{ translateText('Submit', lang_admin()) }}
                            </button>
                            <span style="display: none" x-show="isUploading" class="text-info">
                                    Uploading...
                                    <i class="fas fa-spinner fa-spin me-2"></i>
                                </span>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('styles')
        <style>
            .preview-img { max-width: 150px; height: auto; border-radius: 8px; }
            .file-section { background: #f8f9fa; padding: 20px; border-radius: 12px; }
            .btn-delete { font-size: 0.85rem; padding: 5px 10px; }
            .form-label { font-weight: 500; color: #333; }
            .form-control { border-radius: 8px; }
        </style>
    @endpush

    @push('scripts')
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.store('formState', {
                    socialMedia: @js($data['social_media'] ?? []),
                    updateSocialMedia(value) { this.socialMedia = value; }
                });

                Alpine.data('socialMediaManager', () => ({
                    socialMedia: Alpine.store('formState').socialMedia,
                    addSocialMedia() {
                        this.socialMedia.push({ type: '', value: '' });
                        Alpine.store('formState').updateSocialMedia(this.socialMedia);
                    },
                    removeSocialMedia(index) {
                        this.socialMedia.splice(index, 1);
                        Alpine.store('formState').updateSocialMedia(this.socialMedia);
                    },
                    init() {
                        this.$watch('socialMedia', (value) => {
                            Alpine.store('formState').updateSocialMedia(value);
                        });
                        this.$el.closest('form').addEventListener('submit', () => {
                        @this.set('data.social_media', Alpine.store('formState').socialMedia);
                        });
                    }
                }));
            });
        </script>
    @endpush
</div>