<div>
    <livewire:dashboard.page-title :page_title="$page_title" />

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5>{{ $title }}</h5>
                    </div>
                    <div class="card-body">
                        <form enctype="multipart/form-data" x-data="{ isUploading: false }" wire:submit.prevent="save">
                            <div class="row mt-3"
                                 x-on:livewire-upload-start="isUploading = true"
                                 x-on:livewire-upload-finish="isUploading = false"
                                 x-on:livewire-upload-error="isUploading = false"
                            >
                                <div class="mb-3" wire:ignore>
                                    <livewire:components.editor
                                            :value="$data['text']"
                                            field="text"
                                            :required="true"
                                            :label="translateText('QA/QC Process', lang_admin())"
                                            :uniqueKey="'text'"
                                            :language="'en'"
                                            :contentsLangDirection="'ltr'"
                                            :height="'400px'"
                                            :toolbar="$tools"
                                            wire:key="'editor-text'" />
                                </div>
                            </div>

                            <button style="display: none" x-show="!isUploading" wire:loading.attr="disabled" type="submit" class="btn btn-primary mt-3">
                                {{ translateText('Submit', lang_admin()) }}
                            </button>
                            <span style="display: none" x-show="isUploading" class="text-info">
                                Uploading...
                                <i class="fas fa-spinner fa-spin me-2"></i>
                            </span>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')

@endpush

@push('scripts')
@endpush