<div>
    <livewire:dashboard.page-title :page_title="$page_title" />

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5>{{ $title }}</h5>
                    </div>
                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <div class="row">
                                <div wire:ignore class="col-md-6 mb-3">
                                    <label>{{ translateText('Import & Export License', lang_admin()) }}</label>
                                    <div class="form-check form-switch form-check-reverse" style="padding-left: 20px">
                                        <input wire:model="data.import_export_license" class="form-check-input badge-light-info ms-2" id="flexSwitchCheckReverse" type="checkbox" {{ $data['import_export_license'] == 'yes' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="flexSwitchCheckReverse">
                                            {{ translateText('Do you have an import and export license?', lang_admin()) }}
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$annual_turnovers"
                                            :value="$data['annual_turnover']"
                                            field="annual_turnover"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Annual Turnover', lang_admin()) . ' (Million US$)'"
                                            placeholder="{{ translateText('Select Annual Turnover', lang_admin()) }}"
                                            uniqueKey="annual_turnover" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$export_revenues"
                                            :value="$data['export_revenue']"
                                            field="export_revenue"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Export Revenue', lang_admin()) . ' (Million US$)'"
                                            placeholder="{{ translateText('Select Export Revenue', lang_admin()) }}"
                                            uniqueKey="export_revenue" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$total_capitalizations"
                                            :value="$data['total_capitalization']"
                                            field="total_capitalization"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Total Capitalization', lang_admin()) . ' (US$)'"
                                            placeholder="{{ translateText('Select Total Capitalization', lang_admin()) }}"
                                            uniqueKey="total_capitalization" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <livewire:components.tom-select
                                            :options="$countries"
                                            :value="$data['nearest_port']"
                                            field="nearest_port"
                                            :isMultiple="false"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Nearest Port', lang_admin())"
                                            placeholder="{{ translateText('Select Nearest Port', lang_admin()) }}"
                                            uniqueKey="nearest_port" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Export Percentage', lang_admin()) }}</label>
                                    <input type="number" wire:model="data.export_percentage" class="form-control" min="0" max="100">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <livewire:components.tom-select
                                            :options="$trade_terms"
                                            :value="$data['terms_of_trades']"
                                            field="terms_of_trades"
                                            :isMultiple="true"
                                            :immediateUpdate="false"
                                            :required="true"
                                            :label="translateText('Terms of Trade', lang_admin())"
                                            placeholder="{{ translateText('Select Terms of Trade', lang_admin()) }}"
                                            uniqueKey="terms_of_trades" />
                                </div>

                                <div class="col-md-12 text-left">
                                    <button type="submit" class="btn btn-primary mt-3">
                                        {{ translateText('Submit', lang_admin()) }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')

@endpush

@push('scripts')
@endpush