<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>
    <div class="container-fluid" x-data="{tab:1,formTab:1,createGroup: false}">
        <div class="btn-group btn-group-sm mb-2 d-table" role="group">
            <button :class="{'btn-primary text-white': tab == 1}" @click="tab = 1"
                    class="btn btn-outline-primary">{{ translateText('By Category', lang_admin()) }}</button>
            <button :class="{'btn-primary text-white': tab == 2}" @click="tab = 2"
                    class="btn btn-outline-primary">{{ translateText('By Ai', lang_admin()) }}</button>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card" x-show="tab == 1">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5>{{ $title.' | '.translateText('By Category', lang_admin()) }}</h5>
                        <div class="d-flex align-items-center">
                            <button :class="{'btn-primary text-white': formTab == 1}" @click="formTab = 1" class="btn btn-outline-danger circle-btn">1</button>
                            <div class="pagination-divider"></div>
                            <button :class="{'btn-primary text-white': formTab == 2}" @click="formTab = 2" class="btn btn-outline-danger circle-btn">2</button>
                            <div class="pagination-divider"></div>
                            <button :class="{'btn-primary text-white': formTab == 3}" @click="formTab = 3" class="btn btn-outline-danger circle-btn">3</button>
                            <div class="pagination-divider"></div>
                            <button :class="{'btn-primary text-white': formTab == 4}" @click="formTab = 4" class="btn btn-outline-danger circle-btn">4</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form enctype="multipart/form-data" x-data="{ isUploading: false }" wire:submit.prevent="save"
                              x-on:submit="$dispatch('update-ckeditor-values')">
                            <div class=""
                                 x-on:livewire-upload-start="isUploading = true"
                                 x-on:livewire-upload-finish="isUploading = false"
                                 x-on:livewire-upload-error="isUploading = false">
                                <div class="row" x-show="formTab == 1">
                                    <h5 class="mb-4 text-secondary">{{translateText('Main Product Information', lang_admin()) }}</h5>
                                    <div class="col-md-12 mb-3" x-data="{tabB: 'en'}">
                                        <label>{{ translateText('Product Details', lang_admin()) }}</label>

                                        <nav class="nav nav-tabs">
                                            @foreach(tab_langs() as $lang)
                                                <button class="nav-link"
                                                        :class="{'active' : tabB == '{{$lang->lang}}'}"
                                                        type="button"
                                                        @click="tabB = '{{$lang->lang}}'">
                                                    {{ strtoupper($lang->lang) }}
                                                </button>
                                            @endforeach
                                        </nav>

                                        <div class="tab-content p-3 border border-top-0">
                                            @foreach(tab_langs() as $lang)
                                                @php
                                                    $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                                    $dir = $lang->align;
                                                    $uniqueKey = "description{$suffix}";
                                                @endphp

                                                <div class="tab-pane"
                                                     :class="{'show active d-block' : tabB == '{{$lang->lang}}'}"
                                                     x-show="tabB == '{{$lang->lang}}'"
                                                     style="direction: {{ $dir }}">

                                                    <div wire:ignore class="col-md-12 mb-3" style="direction:ltr">
                                                        <label>{{ translateText('Status', lang_admin()) }}</label>
                                                        <div class="form-check form-switch form-check-reverse"
                                                             style="padding-left: 20px">
                                                            <input wire:model="data.status{{ $suffix }}"
                                                                   class="form-check-input badge-light-info ms-2"
                                                                   id="flexSwitchCheckReverse{{ $suffix }}" type="checkbox">
                                                            <label class="form-check-label"
                                                                   for="flexSwitchCheckReverse{{ $suffix }}">
                                                                {{ translateText('Will it be published?', lang_admin()) }}
                                                            </label>
                                                        </div>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label>
                                                            {{ translateText('Product Name', lang_admin()) }}
                                                            {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                                        </label>
                                                        <input type="text"
                                                               wire:model.defer="data.title{{ $suffix }}"
                                                               class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label>
                                                            {{ translateText('Meta Title', lang_admin()) }}
                                                        </label>
                                                        <input type="text"
                                                               wire:model.defer="data.meta_title{{ $suffix }}"
                                                               class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label>
                                                            {{ translateText('Meta Description', lang_admin()) }}
                                                        </label>
                                                        <input type="text"
                                                               wire:model.defer="data.meta_description{{ $suffix }}"
                                                               class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <livewire:components.tom-select
                                                                :options="$trendingKeywords"
                                                                :value="$data['keywords']"
                                                                field="keywords{{ $suffix }}"
                                                                :isMultiple="true"
                                                                :immediateUpdate="false"
                                                                :keyword="true"
                                                                :required="$lang->status == 'default' ? true : false"
                                                                :label="translateText('Product Keywords', lang_admin())"
                                                                placeholder="{{ translateText('Enter or select product keywords.', lang_admin()) }}"
                                                                uniqueKey="keywords{{ $suffix }}"
                                                                wire:key="keywords{{ $suffix }}"/>
                                                    </div>

                                                    <div class="mb-3">
                                                        <livewire:components.editor
                                                                :value="$data['description' . $suffix] ?? ''"
                                                                field="description{{ $suffix }}"
                                                                :required="$lang->status == 'default'"
                                                                :label="translateText('Product Description', lang_admin())"
                                                                :uniqueKey="$uniqueKey"
                                                                :language="$lang->lang"
                                                                :contentsLangDirection="$dir"
                                                                :height="'300px'"
                                                                :toolbar="$tools"
                                                                wire:key="editor-{{ $uniqueKey }}"/>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-3" wire:ignore>
                                        <label>
                                            {{ translateText('Slug', lang_admin()) }}
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="text"
                                               wire:model="data.slug"
                                               class="form-control"
                                               placeholder="e.g. my-product-title"
                                               dir="ltr"
                                               x-maska
                                               data-maska="A"
                                               data-maska-tokens="A:[a-z0-9\s-]:repeated| -: |-"
                                               x-init="$el.addEventListener('input', () => { $el.value = $el.value.toLowerCase().replace(/\s+/g, '-'); })">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>{{ translateText('Selected Category', lang_admin()) }} <span
                                                    class="text-danger">*</span></label>
                                        <div @click="$wire.dispatch('open-category-selector')"
                                             class="form-control pointer">
                                            {!! $categoryTitle ?? "<span class='text-secondary fw-light'>Click to open modal!</span>"!!}
                                        </div>
                                        <span class="mt-1">{{translateText("Can't find what are you looking for?",lang_admin())}} <a
                                                    href="#"
                                                    class="text-primary">{{translateText('Suggest a category!',lang_admin())}}</a></span>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>{{ translateText('Product Group', lang_admin())}}</label>
                                        <div class="d-flex mb-2 input-group">
                                            <livewire:components.tom-select
                                                    :disabled="$data['category_id'] == null ? true : false"
                                                    :options="$groups"
                                                    :value="$data['group_id']"
                                                    field="group_id"
                                                    :immediateUpdate="false"
                                                    :keyword="true"
                                                    :style="['at'=>'width', 'val'=>'85%' ]"
                                                    placeholder="{{ translateText('Type a new group name or select one...', lang_admin()) }}"
                                                    uniqueKey="group_id"
                                                    wire:key="group_id"/>
                                            <button wire:click="saveGroup" {{$data['category_id'] == null ? 'disabled' : ''}} style="height: 37.6px" class="btn btn-primary" type="button">{{ translateText('Add', lang_admin()) }}</button>
                                        </div>
                                        <span class="mt-1">{{translateText("You can select one of the groups you have already added or add a new one.",lang_admin())}}</span>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label>{{ translateText('Brand Name', lang_admin()) }} </label>
                                        <input class="form-control" wire:model="data.brand">
                                    </div>
                                    <div class="col-md-6 mb-3" x-data="{
                                            part1: '',
                                            part2: '',
                                            part3: '',
                                            part4: '',
                                            updateFullCode() {
                                                const fullCode = [this.part1, this.part2, this.part3, this.part4]
                                                    .map(part => part.padStart(part === this.part1 ? 4 : 2, '0'))
                                                    .join('.');
                                                this.$refs.hiddenInput.value = fullCode;
                                                this.$wire.set('data.us_hts_code', fullCode);
                                            }
                                        }">
                                        <label>{{ translateText('US HTS Code', lang_admin()) }}</label>
                                        <div class="multi-segment-input d-flex gap-2">
                                            <input
                                                    x-model="part1"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="4444"
                                                    class="form-control text-center"
                                                    maxlength="4"
                                                    style="width: 25%;"
                                            >
                                            <span>.</span>
                                            <input
                                                    x-model="part2"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="00"
                                                    class="form-control text-center"
                                                    maxlength="2"
                                                    style="width: 15%;"
                                            >
                                            <span>.</span>
                                            <input
                                                    x-model="part3"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="22"
                                                    class="form-control text-center"
                                                    maxlength="2"
                                                    style="width: 15%;"
                                            >
                                            <span>.</span>
                                            <input
                                                    x-model="part4"
                                                    @input="updateFullCode"
                                                    type="text"
                                                    placeholder="33"
                                                    class="form-control text-center"
                                                    maxlength="2"
                                                    style="width: 15%;"
                                            >
                                            <input
                                                    type="hidden"
                                                    x-ref="hiddenInput"
                                                    wire:model="data.us_hts_code"
                                                    id="hts-code-input"
                                            >
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>{{ translateText('Model Number', lang_admin()) }} </label>
                                        <input type="number" class="form-control"
                                               wire:model="data.model_number">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <livewire:components.tom-select
                                                :options="$countries"
                                                :value="$data['place_of_origin']"
                                                field="place_of_origin"
                                                :immediateUpdate="false"
                                                :label="translateText('Place of origin', lang_admin())"
                                                placeholder="{{ translateText('Select Country', lang_admin()) }}"
                                                uniqueKey="place_of_origin"
                                                wire:key="tom-select-place_of_origin"/>
                                    </div>
                                    <div class="col-md-12 mb-3" x-data="{ showOtherInput: false }">
                                        <label>{{ translateText('Product Certifications', lang_admin()) }}</label>
                                        <div class="row">
                                            <div class="col-md-12 row">
                                                @foreach($certifications as $item)
                                                    <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                        <input class="form-check-input" type="checkbox"
                                                               wire:model="data.certifications" value="{{$item}}"
                                                               id="{{$item}}">
                                                        <label class="form-check-label"
                                                               for="{{$item}}">{{$item}}</label>
                                                    </div>
                                                @endforeach
                                            </div>

                                            <div class="col-md-12 p-0">
                                                <div class="form-check form-check-inline checkbox checkbox-primary mb-0">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.certifications" value="other" id="other"
                                                           x-model="showOtherInput">
                                                    <label class="form-check-label"
                                                           for="other">{{ translateText('OTHER', lang_admin()) }}</label>
                                                </div>

                                                <div x-show="showOtherInput" class="">
                                                    <livewire:components.tom-select
                                                            :options="[]"
                                                            :value="$data['other_certification']"
                                                            field="other_certification"
                                                            :immediateUpdate="false"
                                                            :isMultiple="true"
                                                            :keyword="true"
                                                            placeholder="{{ translateText('Please write another certificate. You can write multiple ones.', lang_admin()) }}"
                                                            uniqueKey="other_certification"
                                                            wire:key="other_certification"/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <livewire:components.file-upload
                                                type="gallery"
                                                :isMultiple="true"
                                                :label="translateText('Product Images', lang_admin())"
                                                acceptedFormats="jpeg,jpg,png,webp"
                                                maxSize="5120"
                                                dimensions="600x600"
                                                modelClass="\App\Models\Product"
                                                :required="true"
                                                uniqueKey="file-upload-gallery"
                                                wire:key="file-upload-gallery"
                                                uploadDisk="livewire_file"
                                                pathPrefix="assets/admin/uploads/product"
                                                :maxFiles="5"
                                                :applyWatermark="false"
                                        />
                                        <span class="mt-1">{{translateText("For more information read",lang_admin())}} <a
                                                    href="#"
                                                    class="text-primary">{{translateText('Guiedlines',lang_admin())}}</a></span>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <livewire:components.file-upload
                                                type="brochure"
                                                :isMultiple="false"
                                                :label="translateText('Product Brochure', lang_admin())"
                                                acceptedFormats="pdf,jpg"
                                                maxSize="10240"
                                                modelClass="\App\Models\Product"
                                                :required="false"
                                                uniqueKey="file-upload-brochure"
                                                wire:key="file-upload-brochure"
                                                uploadDisk="livewire_file"
                                                pathPrefix="assets/admin/uploads/product"/>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <livewire:components.file-upload
                                                type="video"
                                                :isMultiple="false"
                                                :label="translateText('Product Video', lang_admin())"
                                                acceptedFormats="mp4"
                                                maxSize="10240"
                                                modelClass="\App\Models\Product"
                                                :required="false"
                                                uniqueKey="file-upload-video"
                                                wire:key="file-upload-video"
                                                uploadDisk="livewire_file"
                                                pathPrefix="assets/admin/uploads/Product"/>
                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <livewire:components.file-upload
                                                type="certificates"
                                                :isMultiple="true"
                                                :label="translateText('Product Certificates', lang_admin())"
                                                acceptedFormats="pdf,jpg"
                                                maxSize="10240"
                                                modelClass="\App\Models\Product"
                                                uniqueKey="file-upload-certificates"
                                                wire:key="file-upload-certificates"
                                                uploadDisk="livewire_file"
                                                pathPrefix="assets/admin/uploads/product"
                                                :maxFiles="5"
                                                :applyWatermark="false"
                                        />
                                    </div>
                                </div>

                                <div class="row" x-show="formTab == 2">
                                    <h5 class="mb-4 text-secondary">{{translateText('Main product attributes', lang_admin()) }}</h5>
                                    <div class="col-md-12 mb-3" x-data="{tabA:en}">
                                        <label>{{ translateText('Product Attributes', lang_admin()) }}</label>

                                        <nav class="nav nav-tabs">
                                            @foreach(tab_langs() as $lang)
                                                <button class="nav-link"
                                                        :class="{'active' : tabA == {{$lang->lang}}}"
                                                        type="button"
                                                        @click="tabA = {{$lang->lang}}">
                                                    {{ strtoupper($lang->lang) }}
                                                </button>
                                            @endforeach
                                        </nav>

                                        <div class="tab-content p-3 border border-top-0">
                                            @foreach(tab_langs() as $lang)
                                                @php
                                                    $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                                    $dir = $lang->align;
                                                @endphp

                                                <div class="tab-pane fade"
                                                     :class="{'show active d-block' : tabA == {{$lang->lang}}}"
                                                     id="{{$lang->lang}}"
                                                     x-show="tabA == {{$lang->lang}}"
                                                     style="direction: {{ $dir }}">

                                                    <div id="attributes-container{{ $suffix }}">
                                                        @foreach($data['attributes' . $suffix] ?? [] as $index => $attribute)
                                                            <div class="d-flex mb-2 input-group">
                                                                <input type="text"
                                                                       wire:model="data.attributes{{ $suffix }}.{{ $index }}.title"
                                                                       class="form-control"
                                                                       placeholder="{{ translateText('Attribute name', lang_admin()) }}">

                                                                <input type="text"
                                                                       wire:model="data.attributes{{ $suffix }}.{{ $index }}.value"
                                                                       class="form-control"
                                                                       placeholder="{{ translateText('Attribute value', lang_admin()) }}">

                                                                <button type="button"
                                                                        wire:click="removeAttribute({{ $index }}, '{{ $lang->lang }}')"
                                                                        class="btn btn-danger">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                        @endforeach
                                                    </div>

                                                    <button type="button"
                                                            wire:loading.attr="disabled"
                                                            wire:click="addAttribute('{{ $lang->status == 'default' ? '' : $lang->lang }}')"
                                                            class="btn btn-success mt-2">
                                                        <i class="fas fa-plus"></i> {{ translateText('Add Attribute', lang_admin()) }}
                                                    </button>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>

                                <div class="row" x-show="formTab == 3">
                                    <h5 class="mb-4 text-secondary">{{translateText('Product Price & Logestic Information', lang_admin()) }}</h5>
                                    <div class="col-md-12 mb-3">
                                        <label>
                                            {{ translateText('Minimum Order', lang_admin()) }}
                                            <span class='text-danger'>*</span>
                                        </label>
                                        <div class="d-flex mb-2 input-group">
                                            <input wire:model="data.minimum_quantity"
                                                   type="text"
                                                   class="form-control"
                                                   placeholder="{{ translateText('Enter Quantity', lang_admin()) }}">

                                            <livewire:components.tom-select
                                                    :options="$units"
                                                    :value="$data['minimum_unit']"
                                                    field="minimum_unit"
                                                    :immediateUpdate="false"
                                                    :style="['at'=>'width', 'val'=>'50%' ]"
                                                    placeholder="{{ translateText('Select Unit', lang_admin()) }}"
                                                    uniqueKey="minimum_unit"
                                                    wire:key="minimum_unit"/>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3" x-data="{priceTab:'fixed_price'}">
                                        <label>
                                            {{ translateText('FOB Price', lang_admin()) }}
                                            <span class='text-danger'>*</span>
                                        </label>
                                        <div class="form-check radio radio-primary ps-0 main-icon-radio">
                                            <ul class="radio-wrapper justify-content-around">
                                                <li><input @click="priceTab = 'fixed_price'" class="form-check-input"
                                                           id="fixed_price" type="radio"
                                                           wire:model="data.fob_price" value="fixed_price"><label
                                                            class="form-check-label" for="fixed_price"><i
                                                                class="fa-solid fa-lock"></i><span>{{translateText('Fixed Price',lang_admin())}}</span></label>
                                                </li>
                                                <li><input @click="priceTab = 'ladder_price'" class="form-check-input"
                                                           id="ladder_price" type="radio"
                                                           wire:model="data.fob_price" value="ladder_price"
                                                           checked=""><label
                                                            class="form-check-label" for="ladder_price"><i
                                                                class="fa-solid fa-chart-line"></i><span>{{translateText('Ladder Price',lang_admin())}}</span></label>
                                                </li>
                                                <li><input @click="priceTab = 'price_range'" class="form-check-input"
                                                           id="price_range" type="radio"
                                                           wire:model="data.fob_price" value="price_range"><label
                                                            class="form-check-label" for="price_range"><i
                                                                class="fa-solid fa-arrows-alt-h"></i><span>{{translateText('Price Range',lang_admin())}}</span></label>
                                                </li>
                                                <li><input @click="priceTab = 'negotiable'" class="form-check-input"
                                                           id="negotiable" type="radio"
                                                           wire:model="data.fob_price" value="negotiable"><label
                                                            class="form-check-label" for="negotiable"><i
                                                                class="fa-solid fa-handshake"></i><span>{{translateText('Negotiable',lang_admin())}}</span></label>
                                                </li>
                                            </ul>
                                        </div>

                                        <div x-show="priceTab == 'fixed_price'" class="mt-3">
                                            <label>
                                                {{ translateText('Fixed Price', lang_admin()) }}
                                                <span class='text-danger'>*</span>
                                            </label>
                                            <div class="d-flex mb-2 input-group">
                                                <input wire:model="data.amount" type="number" class="form-control"
                                                       placeholder="{{ translateText('Enter Price (US$)', lang_admin()) }}">
                                                <select wire:model="data.minimum_unit" disabled class="form-control">
                                                    <option value="">{{translateText('(Unit)',lang_admin())}}</option>
                                                    @foreach($units as $key => $unit)
                                                        <option value="{{$key}}">{{$unit}}</option>
                                                    @endforeach
                                                </select>
                                                <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.negotiable" value="Negotiable"
                                                           id="Negotiable">
                                                    <label class="form-check-label"
                                                           for="Negotiable">{{translateText('Negotiable',lang_admin())}}</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div x-show="priceTab == 'ladder_price'" class="mt-3"
                                             x-data="ladderPriceManager()">
                                            <label>
                                                {{ translateText('Ladder Price', lang_admin()) }}
                                                <span class='text-danger'>*</span>
                                            </label>

                                            <template x-for="(item, index) in ladderPrices" :key="index">
                                                <div class="d-flex mb-2 input-group">
                                                    <input x-model="item.fixed_quantity" type="number"
                                                           class="form-control"
                                                           placeholder="{{ translateText('MOQ', lang_admin()) }}"
                                                           min="1" >
                                                    <input x-model="item.fixed_price" type="number" class="form-control"
                                                           placeholder="{{ translateText('Price (US$)', lang_admin()) }}"
                                                           min="0" step="0.01" >
                                                    <button type="button" class="btn btn-danger"
                                                            @click="removeLadder(index)"
                                                            x-show="ladderPrices.length > 1">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </template>

                                            <button type="button" class="btn btn-sm btn-success mb-3"
                                                    @click="addNewLadder">
                                                <i class="fas fa-plus"></i> {{ translateText('Add New Price Step', lang_admin()) }}
                                            </button>

                                            <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                <input class="form-check-input" type="checkbox"
                                                       wire:model="data.negotiable"
                                                       value="Negotiable" id="Negotiable">
                                                <label class="form-check-label" for="Negotiable">
                                                    {{translateText('Negotiable',lang_admin())}}
                                                </label>
                                            </div>
                                        </div>
                                        <div x-show="priceTab == 'price_range'" class="mt-3">
                                            <label>
                                                {{ translateText('Price Range', lang_admin()) }}
                                                <span class='text-danger'>*</span>
                                            </label>
                                            <div class="d-flex mb-2 input-group">
                                                <input wire:model="data.amount" type="number" class="form-control"
                                                       placeholder="{{translateText('Min Price (US$)',lang_admin())}}">
                                                <input wire:model="data.max_amount" type="number" class="form-control"
                                                       placeholder="{{translateText('Max Price (US$)',lang_admin())}}">
                                                <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.negotiable" value="Negotiable"
                                                           id="Negotiable">
                                                    <label class="form-check-label"
                                                           for="Negotiable">{{translateText('Negotiable',lang_admin())}}</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div x-show="priceTab == 'negotiable'" class="mt-3">
                                            <label>
                                                {{ translateText('Negotiable', lang_admin()) }}
                                            </label>
                                            <div class="d-flex mb-2 input-group">
                                                {{translateText("Price can be negotiated depending on buyer's requirements. Please contact us for further discussion.",lang_admin())}}
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label>{{translateText('Lead Time',lang_admin())}}</label>
                                        <div class="d-flex mb-2 input-group align-items-center">
                                            <span class="mx-2">Between</span>
                                            <input wire:model="data.lead_time_start" class="form-control"
                                                   placeholder="e.g. 5">
                                            <span class="mx-2">to</span>
                                            <input wire:model="data.lead_time_end" class="form-control"
                                                   placeholder="e.g. 12">
                                            <span class="mx-2">days</span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <livewire:components.tom-select
                                                :options="$countries"
                                                :value="$data['nearest_port']"
                                                field="nearest_port"
                                                :immediateUpdate="false"
                                                :label="translateText('Nearest Port', lang_admin())"
                                                placeholder="{{ translateText('Select Country', lang_admin()) }}"
                                                uniqueKey="nearest_port"
                                                wire:key="tom-select-nearest_port"/>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <livewire:components.tom-select
                                                :options="$countries"
                                                :value="$data['main_market']"
                                                field="main_market"
                                                :immediateUpdate="false"
                                                :isMultiple="true"
                                                :label="translateText('Main Market(s)', lang_admin())"
                                                placeholder="{{ translateText('Select Regions', lang_admin()) }}"
                                                uniqueKey="main_market"
                                                wire:key="tom-select-main_market"/>
                                    </div>
                                    <div class="col-md-12 mb-3" x-data="{ showOtherInputMethod: false }">
                                        <label>{{ translateText('Payment Methods', lang_admin()) }}</label>
                                        <div class="row">
                                            <div class="col-md-12 row">
                                                @foreach($paymentMethods as $item)
                                                    <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                                        <input class="form-check-input" type="checkbox"
                                                               wire:model="data.payment_methods" value="{{$item}}"
                                                               id="{{$item}}">
                                                        <label class="form-check-label"
                                                               for="{{$item}}">{{$item}}</label>
                                                    </div>
                                                @endforeach
                                            </div>

                                            <div class="col-md-12 p-0">
                                                <div class="form-check form-check-inline checkbox checkbox-primary mb-0">
                                                    <input class="form-check-input" type="checkbox"
                                                           wire:model="data.payment_methods" value="other"
                                                           id="otherMethod"
                                                           x-model="showOtherInputMethod">
                                                    <label class="form-check-label"
                                                           for="otherMethod">{{ translateText('OTHER', lang_admin()) }}</label>
                                                </div>

                                                <div x-show="showOtherInputMethod">
                                                    <livewire:components.tom-select
                                                            :options="[]"
                                                            :value="$data['other_payment_methods']"
                                                            field="other_payment_methods"
                                                            :immediateUpdate="false"
                                                            :isMultiple="true"
                                                            :keyword="true"
                                                            placeholder="{{ translateText('Please write another payment method. You can write multiple ones.', lang_admin()) }}"
                                                            uniqueKey="other_payment_methods"
                                                            wire:key="other_payment_methods"/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-8 mb-3" x-data="{ showInput: false }">
                                        <label>{{translateText('Sample Option',lang_admin())}}</label>
                                        <div class="card-wrapper  rounded-3 h-100">
                                            <div class="form-check radio radio-primary">
                                                <input @click="showInput = true" class="form-check-input"
                                                       id="yes" type="radio" wire:model="data.sample_option"
                                                       value="yes">
                                                <label class="form-check-label" for="yes">
                                                    {{translateText('Yes',lang_admin())}}
                                                </label>
                                            </div>
                                            <div class="form-check radio radio-primary">
                                                <input @click="showInput = false" class="form-check-input"
                                                       id="no" type="radio" wire:model="data.sample_option"
                                                       value="no">
                                                <label class="form-check-label" for="no">
                                                    {{translateText('No',lang_admin())}}
                                                </label>
                                            </div>
                                            <div class="form-check radio radio-primary">
                                                <input @click="showInput = false" class="form-check-input"
                                                       id="contact" type="radio" wire:model="data.sample_option"
                                                       value="contact">
                                                <label class="form-check-label" for="contact">
                                                    {{translateText('Contact us for sample request information',lang_admin())}}
                                                </label>
                                            </div>
                                            <div x-show="showInput" class=" mb-2 input-group align-items-center">
                                                <span class="mx-2">{{translateText('Between',lang_admin())}}</span>
                                                <input wire:model="data.sample_option_start" class="form-control"
                                                       placeholder="{{translateText('Quantity',lang_admin())}}">
                                                <span class="mx-2">{{translateText('to',lang_admin())}}</span>
                                                <input wire:model="data.sample_option_end" class="form-control"
                                                       placeholder="{{translateText('Quantity',lang_admin())}}">
                                                <input wire:model="data.sample_option_price" class="form-control"
                                                       placeholder="{{translateText('Sample Price(US$)',lang_admin())}}">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row" x-show="formTab == 4">
                                    <h5 class="mb-4 text-secondary">{{translateText('Packaging Information', lang_admin()) }}</h5>
                                    <div class="col-md-6 mb-3">
                                        <label>{{translateText('Product Dimensions (With Packaging)', lang_admin())}}</label>
                                        <div class="d-flex input-group mb-2 align-items-center">
                                            <input wire:model="data.length" class="form-control" placeholder="Length">
                                            <input wire:model="data.width" class="form-control" placeholder="Width">
                                            <input wire:model="data.height" class="form-control" placeholder="Height">
                                            <livewire:components.tom-select
                                                    :options="$unit_of_measurement"
                                                    :value="$data['unit1']"
                                                    field="unit1"
                                                    :immediateUpdate="false"
                                                    placeholder="{{ translateText('Select Unit', lang_admin()) }}"
                                                    uniqueKey="unit1"
                                                    wire:key="unit1"/>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>{{translateText('Product Weight (With Packaging)', lang_admin())}}</label>
                                        <div class="d-flex input-group mb-2 align-items-center">
                                            <input wire:model="data.weight" class="form-control" placeholder="Weight">
                                            <livewire:components.tom-select
                                                    :options="$units"
                                                    :value="$data['unit2']"
                                                    field="unit2"
                                                    :immediateUpdate="false"
                                                    :style="['at'=>'width', 'val'=>'50%' ]"
                                                    placeholder="{{ translateText('Select Unit', lang_admin()) }}"
                                                    uniqueKey="unit2"
                                                    wire:key="unit2"/>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <div class="form-check form-check-inline checkbox checkbox-dark mb-0 col-3">
                                            <input class="form-check-input" type="checkbox" wire:model="data.showcase" id="showcase">
                                            <label class="form-check-label" for="showcase">{{translateText('Mark as Showcase',lang_admin())}}</label>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <div class="form-check form-check-inline checkbox checkbox-dark mb-0">
                                            <input class="form-check-input" type="checkbox" wire:model.live="data.conditions" id="conditions">
                                            <label class="form-check-label" for="conditions">{{translateText('I hereby confirm that all submitted information is true and complies with Mainexpo’s Terms of Use. I take full responsibility for any violation, and Mainexpo reserves the right to remove any content that breaches its policies.',lang_admin())}}</label>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="d-flex justify-content-between mt-4">
                                <button
                                        type="button"
                                        class="btn btn-secondary"
                                        @click="formTab--"
                                        x-show="formTab > 1"
                                >
                                    <i class="fas fa-arrow-left me-2"></i> Previous
                                </button>

                                <button
                                        type="button"
                                        class="btn btn-info ms-auto"
                                        @click="formTab++"
                                        x-show="formTab < 4"
                                >
                                    Next <i class="fas fa-arrow-right me-2"></i>
                                </button>
                                @if($data['conditions'])
                                    <button x-show="!isUploading && formTab == 4" wire:loading.attr="disabled"
                                            type="submit" class="btn btn-primary ms-auto">
                                        {{ translateText('Submit', lang_admin()) }}
                                    </button>
                                @else
                                    <span x-show="!isUploading && formTab == 4" class="text-danger">{{ translateText('First agree to the terms and conditions.', lang_admin()) }}</span>
                                @endif
                                <span x-show="isUploading" class="text-info">
                                Uploading...
                                <i class="fas fa-spinner fa-spin me-2"></i>
                            </span>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card" x-show="tab == 2">
                    <div class="card-header">
                        <h5>{{ $title.' | '.translateText('By Ai', lang_admin()) }}</h5>
                    </div>
                    <div class="card-body">
                        By Ai
                    </div>
                </div>
            </div>
        </div>
        <livewire:dashboard.items-and-services.product.category-selector/>
    </div>
</div>
@push('styles')
    <style>
        .pagination-divider {
            height: 1px;
            width: 50px;
            background-color: #dc3545;
            margin: 0 12px;
            align-self: center;
        }
        .circle-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 4px;
        }
    </style>
@endpush
@push('scripts')
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.store('ladderPriceState', {
                ladderPrices: @js($data['ladder_prices'] ?? []),
                updateLadderPrices(value) {
                    this.ladderPrices = value;
                }
            });

            Alpine.data('ladderPriceManager', () => ({
                ladderPrices: Alpine.store('ladderPriceState').ladderPrices,

                addNewLadder() {
                    this.ladderPrices.push({
                        fixed_quantity: '',
                        fixed_price: ''
                    });
                    Alpine.store('ladderPriceState').updateLadderPrices(this.ladderPrices);
                },

                removeLadder(index) {
                    this.ladderPrices.splice(index, 1);
                    Alpine.store('ladderPriceState').updateLadderPrices(this.ladderPrices);
                },

                init() {
                    if (this.ladderPrices.length === 0) {
                        this.addNewLadder();
                    }

                    this.$watch('ladderPrices', (value) => {
                        Alpine.store('ladderPriceState').updateLadderPrices(value);
                    });

                    this.$el.closest('form').addEventListener('submit', () => {
                    @this.set('data.ladder_prices', Alpine.store('ladderPriceState').ladderPrices);
                    });
                }
            }));
        });
    </script>
@endpush