<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>

    <div class="container-fluid datatable-init">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0 card-no-border d-flex justify-content-between">
                        <h5>{{$title}}</h5>
                        <a href="{{route('product.create',$dashboardCode)}}" class="btn btn-success">
                            <i class="fa fa-plus"></i>{{ translateText('Add Product', lang_admin()) }}
                        </a>
                    </div>

                    <div class="card-body" wire:ignore>
                        <div class="table-responsive custom-scrollbar">
                            <table class="display table-striped border" id="basic-1">
                                <thead>
                                <tr>
                                    <th>Thumbnail</th>
                                    <th>Product Title</th>
                                    <th>Category</th>
                                    <th>Group</th>
                                    <th>Owner</th>
                                    <th>Status</th>
                                    <th>Showcase</th>
                                    <th>Last Modified</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($items as $item)
                                    <tr>
                                        <td class="sorting_1">
                                            <img class="img-fluid table-avtar w-50 h-50"
                                                 src="{{ $item->gallery->first() != null ? url($item->gallery->first()->path) : url('assets/dashboard/images/user/1.jpg') }}"
                                                 alt="product_img">
                                        </td>
                                        <td>{{ $item->title }}</td>
                                        <td>{{ $item->category->title }}</td>
                                        <td>{{ $item->group->title ?? '---' }}</td>
                                        <td>{!!  $item->user->getRoleNames()[0]."</br> (".$item->user->name.')' ?? '---'  !!}</td>
                                        <td>
                                            <span class="badge badge-light-{{ $item->status == 'active' ? 'success' : 'warning'}}">{{$item->status}}</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-light-{{ $item->showcase ? 'success' : 'danger'}}">{{$item->showcase ? 'YES' : 'NO'}}</span>
                                        </td>
                                        <td>{{ $item->updated_at }}</td>
                                        <td>
                                            <ul class="action">
                                                <li class="edit">
                                                    <a href="{{route('company-certificate.edit',$item->id)}}"><i class="fa-regular fa-pen-to-square"></i></a>
                                                </li>
                                                <li class="delete">
                                                    <a onclick="deleteItem({{ $item->id }})" style="cursor:pointer;">
                                                        <i class="fa-solid fa-trash-can"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@push('styles')

@endpush
@push('scripts')

@endpush