<div class="col-md-6 order-xl-3 order-md-4 box-ord-3">
    <div class="card monthly-header shadow-sm">
        <div class="card-header border-0 bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-semibold">{{ translateText('Profile Completion', lang_admin()) }}</h5>
                <div class="card-header-right-icon">
                    <i class="fas fa-check"></i>
                </div>
            </div>
        </div>
        <div class="card-body pt-0">
            <div class="d-flex flex-column align-items-start p-3">
                <div x-data="{ percent: $wire.totalCompletion }" class="position-relative mb-3" style="width: 120px; height: 120px;">
                    <svg class="w-100 h-100" viewBox="0 0 100 100">
                        <circle cx="50" cy="50" r="45" fill="none" stroke="#f0f0f0" stroke-width="8"/>
                        <circle cx="50" cy="50" r="45" fill="none" stroke="#4CAF50" stroke-width="8"
                                stroke-linecap="round"
                                stroke-dasharray="283"
                                stroke-dashoffset="283"
                                x-bind:stroke-dashoffset="283 - (283 * percent / 100)"
                                transform="rotate(-90 50 50)"/>
                        <text x="50" y="55" text-anchor="middle" font-size="20" fill="#4CAF50" font-weight="bold" x-text="Math.round(percent) + '%'"></text>
                    </svg>
                </div>

                <div class="w-100 mt-3">
                    <template x-for="(item, index) in [
                            { name: 'General Information', value: $wire.completion.general, max: 20, route: 'general-information' },
                            { name: 'Contact Information', value: $wire.completion.contact, max: 10, route: 'contact-information' },
                            { name: 'Business Information', value: $wire.completion.business, max: 10, route: 'business-information' },
                            { name: 'Trading Information', value: $wire.completion.trading, max: 10, route: 'trading-information' },
                            { name: 'Factory Information', value: $wire.completion.factory, max: 5, route: 'factory-information' },
                            { name: 'Quality Control', value: $wire.completion.quality, max: 5, route: 'quality-control' },
                            { name: 'Company Certificates', value: $wire.completion.certificates, max: 5, route: 'company-office.manage' },
                            { name: 'Company FAQs', value: $wire.completion.faqs, max: 5, route: 'company-certificate.manage' },
                            { name: 'Company Offices', value: $wire.completion.offices, max: 5, route: 'company-faq.manage' },
                            { name: 'Add Products/Services', value: $wire.completion.products, max: 25, route: 'add-products' }
                        ]" :key="index">
                        <div class="d-flex justify-content-between mb-2">
                            <a :href="route(item.route)" class="text-muted" x-text="item.name"></a>
                            <div class="d-flex align-items-center">
                                <span class="fw-medium me-2" x-text="Math.round(item.value) + '/' + item.max"></span>
                                <div class="progress" style="width: 100px; height: 6px;">
                                    <div class="progress-bar bg-success" role="progressbar"
                                         x-bind:style="'width: ' + (item.value / item.max * 100) + '%'"
                                         x-bind:aria-valuenow="item.value"
                                         aria-valuemin="0"
                                         x-bind:aria-valuemax="item.max"></div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        window.route = function(name) {
            const routes = {
                'general-information': '{{ route("general-information",auth()->id()) }}',
                'contact-information': '{{ route("contact-information",auth()->id()) }}',
                'business-information': '{{ route("business-information",auth()->id()) }}',
                'trading-information': '{{ route("trading-information",auth()->id()) }}',
                'factory-information': '{{ route("factory-information",auth()->id()) }}',
                'quality-control': '{{ route("quality-control",auth()->id()) }}',
                'company-office.manage': '{{ route("company-office.manage",auth()->id()) }}',
                'company-certificate.manage': '{{ route("company-certificate.manage",auth()->id()) }}',
                'company-faq.manage': '{{ route("company-faq.manage",auth()->id()) }}',
            };
            return routes[name] || '#';
        };
    </script>
@endpush