<div class="col-md-6 order-xl-2 order-md-3 box-ord-2">
    <div class="card monthly-header shadow-sm">
        <div class="card-header border-0 bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-semibold">{{ translateText('Profile Overview', lang_admin()) }}</h5>
                <div class="card-header-right-icon">
                    <i class="fas fa-user"></i>
                </div>
            </div>
        </div>
        <div class="card-body pt-3 px-4">
            <div class="d-flex align-items-center flex-wrap p-3 rounded-3 mb-3">
                <div class="me-3">
                    <img src="{{ $profilePhoto }}" alt="{{ translateText('Profile Photo', lang_admin()) }}" class="rounded-circle border border-2 border-primary" style="width: 90px; height: 90px; object-fit: cover;">
                </div>
                <div class="flex-grow-1">
                    <h6 class="mb-1 fw-bold">{{ translateText('Welcome', lang_admin()) }} {{ $companyName }}!</h6>
                    @if($countryFlag)
                        <span style="font-size: 24px;">
                            {{ $countryFlag }}
                        </span>
                        <span class="text-muted">{{ $countryName }}</span>
                    @endif
                </div>
            </div>
            <div class="p-3">
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2">{{ translateText('Membership Type', lang_admin()) }}:</span>
                    <span class="fw-semibold text-dark">{{ $membershipType }}</span>
                    <a href="#" class="btn btn-sm btn-primary ms-auto rounded-pill px-3">{{ translateText('Upgrade Now', lang_admin()) }}</a>
                </div>
                <div class="mb-4">
                    <div class="d-flex align-items-center mb-2">
                        <span class="text-muted me-2">{{ translateText('Account Type', lang_admin()) }}:</span>
                        <span class="fw-semibold text-dark">{{ $accountType }}</span>
                    </div>
                    <div class="mt-2 d-flex gap-2">
                        <a href="#" class="btn btn-sm btn-primary rounded-pill">{{ translateText('Create Buyer Account', lang_admin()) }}</a>
                        <a href="#" class="btn btn-sm btn-primary rounded-pill">{{ translateText('Add Service Provider', lang_admin()) }}</a>
                    </div>
                </div>
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2">{{ translateText('Member Since', lang_admin()) }}:</span>
                    <span class="fw-semibold text-dark">{{ $memberSince }}</span>
                </div>
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2">{{ translateText('Email Address', lang_admin()) }}:</span>
                    <span class="fw-semibold text-dark">{{ $email }}</span>
                </div>
                <div class="mb-4 d-flex align-items-center">
                    <span class="text-muted me-2">{{ translateText('Phone Number', lang_admin()) }}:</span>
                    <span class="fw-semibold text-dark">+{{ $phoneNumber }}</span>
                </div>
                <div class="mb-0 d-flex align-items-center">
                    <span class="text-muted me-2">{{ translateText('Company Address', lang_admin()) }}:</span>
                    <span class="fw-semibold text-dark">{{ $companyAddress }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
    <style>

    </style>
@endpush

@push('scripts')
@endpush