<div>
    <a href="" class="banner-box h-auto">
        <img src="{{url('assets/front/new/images/banner-5.jpg')}}" alt="">
    </a>
    
    <section class="breadcrumb container-fluid">
        <ul class="breadcrumb-links">
            <li><a href="{{ route('front.index') }}">{{read_lang_word('home')}}</a></li>
            <li><span class="end-item">{{read_lang_word('categories')}}</span></li>
        </ul>
    </section>

    <section class="section-card py-4">
        <div class="container-fluid">
            <div class="section-heading">
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box">
                        <h6 class="section-heading-title">{{read_lang_word('all-product-categories')}}</h6>
                    </div>
                </div>
            </div>

            <div class="categories-accordion-container">
                <div class="accordion categories-accordion" id="categoriesAccordion">
                    @foreach($this->categories as $category)
                        <livewire:front.category.category-item :category="$category" :key="$category->id" wire:lazy/>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    @push('styles')
        <script defer src="{{url('assets/front/new/js/alpine.min.js')}}"></script>
    @endpush

    @push('scripts')
        <script>
            document.addEventListener('livewire:load', () => {
                console.log('Categories page loaded');
            });
        </script>
    @endpush
</div>