<div class="col-xl-3 col-lg-4 col-md-6"
     x-data="{ open: false }"
>
    <div class="subcategory-section">
        <div class="subcategory-header">
            <button
                    @click="open = !open"
                    class="subcategory-toggle"
                    :aria-expanded="open.toString()"
                    type="button"
            >
                <span>{{ read_lang($subcategory,'title') }}</span>
                <i :class="open ? 'fa-solid fa-minus' : 'fa-solid fa-plus'"></i>
            </button>
        </div>

        <div
                x-show="open"
                x-transition
                class="subcategory-content"
                style="display: none"
        >
            <div class="search-box">
                <input
                        type="text"
                        class="form-control"
                        placeholder="{{read_lang_word('search-in-subcategories')}}"
                >
            </div>
            <div class="subcategory-items">
                <ul>
                    @forelse($this->filteredGrandchildren as $grandchild)
                        <li><a href="#">{{ read_lang($grandchild,'title') }}</a></li>
                    @empty
                        <li>{{read_lang_word('msg-err-not-found')}}.</li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>

@push('styles')
    <script defer src="{{url('assets/front/new/js/alpine.min.js')}}"></script>
@endpush